/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.java;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.java.JARStrategy;
import com.ibm.appscan.internal.discovery.java.stage.JavaStagerStrategy;
import java.io.File;

public class JARStrategyFactory
implements IStrategyFactory {
    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        if (fileOrDirectory.getName().toLowerCase().endsWith(".jar")) {
            if (!SystemUtil.useStagerForJavaFiles()) {
                return new JARStrategy(fileOrDirectory, registry);
            }
            if (registry.useAlternativeStrategy()) {
                return new JavaStagerStrategy(fileOrDirectory, null);
            }
        }
        return null;
    }

    public boolean isBuildOutput() {
        return true;
    }

    public void loadUniqueTarget(IScan scan) {
    }
}

