/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.java;

import com.hcl.appscan.discovery.java.utils.JDKHelper;
import com.hcl.appscan.discovery.java.utils.Util;
import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.java.JavaTargetValidator;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.dir.BaseCollector;
import com.ibm.appscan.discovery.java.Messages;
import com.ibm.appscan.internal.discovery.java.JARStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class JavaCollector
extends BaseCollector {
    private static final String CLASS_EXT = "class";
    private File m_crawlRoot;
    private List<File> m_roots = new ArrayList<File>();
    private IScanTargetProxy m_proxy;

    public JavaCollector(File crawlRoot, IScanTargetProxy proxy, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(includes, excludes);
        this.m_crawlRoot = crawlRoot;
        this.m_proxy = proxy;
        proxy.inheritedSetBuildInfo("additional_classpath", null);
        proxy.inheritedSetBuildInfo("classpath", null);
        proxy.inheritedSetBuildInfo("bootstrap_classpath", null);
        proxy.inheritedSetBuildInfo("extension_jars", null);
    }

    private File findRoot(File file, String pkg) {
        if (!"".equals(pkg)) {
            String[] pkgFragments = pkg.split("\\.");
            for (int i = pkgFragments.length - 1; i >= 0; --i) {
                if ((file = file.getParentFile()) != null && pkgFragments[i].equals(file.getName())) continue;
                return null;
            }
        }
        return file.getParentFile();
    }

    private boolean findRoot(File file) {
        for (File root : this.m_roots) {
            if (!PathUtil.isParent((File)root, (File)file)) continue;
            return true;
        }
        try {
            ClassParser parser = new ClassParser(file.getPath());
            JavaClass clazz = parser.parse();
            File root = this.findRoot(file, clazz.getPackageName());
            if (root == null) {
                return false;
            }
            Iterator<File> iter = this.m_roots.iterator();
            while (iter.hasNext()) {
                if (!PathUtil.isParent((File)root, (File)iter.next())) continue;
                iter.remove();
            }
            this.m_roots.add(root);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void process(File file, String path, IProgress progress) {
        if (!this.findRoot(file)) {
            return;
        }
        if (this.acceptFile(file)) {
            if (file.getName().equalsIgnoreCase("module-info.class")) {
                return;
            }
            IScanFile scanFile = ScanModelFactory.newScanFile((File)file);
            String sourceFile = this.getSourceFile(file, path);
            if (sourceFile == null) {
                return;
            }
            scanFile.setSourcePath(sourceFile);
            scanFile.setExcluded(this.isFileUserExcluded(file));
            if (!scanFile.isExcluded() || SystemUtil.isDryRun()) {
                this.getCollectedFiles().add(scanFile);
            }
        }
    }

    public Set<IScanFile> getScanFiles() {
        if (!this.getCollectedFiles().isEmpty()) {
            Boolean isDirStrategy = (Boolean)this.m_proxy.getProperties().get("isDirStrategy");
            if (isDirStrategy != null && isDirStrategy.booleanValue()) {
                for (File root : this.m_roots) {
                    if (SystemUtil.useStagerForJavaFiles()) {
                        ClasspathUtil.appendToClasspath((String)root.getAbsolutePath(), (IScanTargetMinProxy)this.m_proxy);
                        continue;
                    }
                    this.m_proxy.newScanTargetSkipScanTargetExclusionCheck((ScanTargetStrategy)new JARStrategy(root));
                }
                return Collections.emptySet();
            }
            try {
                JDKHelper.setJDKProperties((IScanTargetMinProxy)this.m_proxy);
            }
            catch (IOException e) {
                this.m_proxy.getErrorManager().reportError(e.getMessage(), "jdk_path", null, 0, (Throwable)e);
            }
        }
        return this.getCollectedFiles();
    }

    protected Set<String> getFileExtensions() {
        HashSet<String> fileExtensions = new HashSet<String>();
        fileExtensions.add(CLASS_EXT);
        return fileExtensions;
    }

    public void validateScanFiles(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
        proxy.getValidationIssues().addAll(new JavaTargetValidator(files, proxy).validate(progress));
    }

    protected String getFileExtensionSetName() {
        return "java";
    }

    private String getSourceFile(File analysisFile, String sourcePath) {
        if (FileUtil.getFileExtension((File)analysisFile).equalsIgnoreCase(CLASS_EXT)) {
            try {
                String packageName = new ClassInfo(analysisFile).getPackageName();
                String className = Util.getJavaFile((String)analysisFile.getName());
                sourcePath = packageName.replace('.', File.separatorChar) + File.separator + className;
            }
            catch (IOException e) {
                sourcePath = Util.getJavaFile((String)sourcePath);
            }
            catch (IllegalArgumentException e) {
                this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("err.java.processing.file", analysisFile.getName())));
                return null;
            }
        }
        if (this.m_proxy != null) {
            sourcePath = this.m_proxy.getSourceAbsolutePath(sourcePath);
        }
        return sourcePath;
    }
}

