/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.android;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.android.IAndroidConstants;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import com.ibm.appscan.file.extension.ExtensionHelper;
import com.ibm.appscan.file.extension.FileExtensionException;
import java.io.File;
import java.util.HashSet;

public class AndroidStrategy
extends FileCollectorStrategy
implements IAndroidConstants {
    protected File m_directory;

    public AndroidStrategy() {
    }

    public AndroidStrategy(File directory) {
        this.m_directory = directory;
        this.init(directory, null);
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        CrawlingStrategy strategy = new CrawlingStrategy(){

            public String getType() {
                return Messages.getMessage((String)"directory", (Object[])new Object[0]);
            }

            protected File getCrawlRoot(IScanTargetMinProxy proxy) {
                return AndroidStrategy.this.m_directory;
            }

            protected String[] getCategories(IBuildInfo buildInfo) {
                return new String[]{"category.kotlin", "category.java.source"};
            }
        };
        strategy.init(this.m_directory, null);
        proxy.newScanTarget((ScanTargetStrategy)strategy);
    }

    public String getType() {
        return "Android-Java";
    }

    public String getLanguageType() {
        return "Android-Java";
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return new String[]{"category.android"};
    }

    protected String getExtensionGroup() {
        return "android-java";
    }

    protected boolean acceptFile(File file) {
        if (this.m_fileExtensions == null) {
            this.m_fileExtensions = new HashSet();
            try {
                this.m_fileExtensions.addAll(ExtensionHelper.getFileExtensions((String)this.getExtensionGroup()));
                this.m_fileExtensions.addAll(ExtensionHelper.getFileExtensions((String)"kotlin"));
                this.m_fileExtensions.addAll(ExtensionHelper.getFileExtensions((String)"java-sco"));
            }
            catch (FileExtensionException e) {
                CommonCore.getLogManager().log(new Message(Messages.getMessage((String)"err.read.file.extensions", (Object[])new Object[]{"android-java kotlin java-sco"}), (Throwable)e));
            }
        }
        return file.getName().equalsIgnoreCase("AndroidManifest.xml") || super.acceptFile(file);
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_directory;
    }
}

