/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.DOMBasedDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class Spring25HandlerCodeAdapter {
    private Map<String, DOMBasedDeploymentDescriptorInfo> file2DeploymentDescInfoMap = HashMapFactory.make();

    public static DOMBasedDeploymentDescriptorInfo createDeploymentDescriptorInfo(String fileName) {
        try {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{fileName}));
            DOMBasedDeploymentDescriptorInfo descInfo = new DOMBasedDeploymentDescriptorInfo(fileName);
            return descInfo;
        }
        catch (IOException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        catch (SAXException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        return null;
    }

    public String getContextParamValue(String xmlConfigFileName, String contextParamName) {
        DOMBasedDeploymentDescriptorInfo descInfo = this.file2DeploymentDescInfoMap.get(xmlConfigFileName);
        if (descInfo != null) {
            return descInfo.getContextParamValue(contextParamName);
        }
        descInfo = Spring25HandlerCodeAdapter.createDeploymentDescriptorInfo(xmlConfigFileName);
        this.file2DeploymentDescInfoMap.put(xmlConfigFileName, descInfo);
        return descInfo.getContextParamValue(contextParamName);
    }

    public String getInitParamsForServletName(String xmlConfigFileName, String servletName, String initParamName) {
        if (servletName == null || initParamName == null) {
            return null;
        }
        DOMBasedDeploymentDescriptorInfo descInfo = this.file2DeploymentDescInfoMap.get(xmlConfigFileName);
        if (descInfo == null) {
            descInfo = Spring25HandlerCodeAdapter.createDeploymentDescriptorInfo(xmlConfigFileName);
            this.file2DeploymentDescInfoMap.put(xmlConfigFileName, descInfo);
        }
        List initParamsList = descInfo.getInitParamsForServletName(servletName);
        for (Pair initParam : initParamsList) {
            if (!initParamName.equalsIgnoreCase((String)initParam.fst)) continue;
            return (String)initParam.snd;
        }
        return null;
    }

    public Set<String> getServletNames(String xmlConfigFileName) {
        DOMBasedDeploymentDescriptorInfo descInfo = this.file2DeploymentDescInfoMap.get(xmlConfigFileName);
        if (descInfo != null) {
            return descInfo.getServletNames();
        }
        descInfo = Spring25HandlerCodeAdapter.createDeploymentDescriptorInfo(xmlConfigFileName);
        this.file2DeploymentDescInfoMap.put(xmlConfigFileName, descInfo);
        return descInfo.getServletNames();
    }

    public String getRootUrl(String xmlConfigFileName) {
        try {
            Collection l;
            DOMBasedDeploymentDescriptorInfo descInfo = this.file2DeploymentDescInfoMap.get(xmlConfigFileName);
            if (descInfo == null) {
                descInfo = Spring25HandlerCodeAdapter.createDeploymentDescriptorInfo(xmlConfigFileName);
                this.file2DeploymentDescInfoMap.put(xmlConfigFileName, descInfo);
            }
            if ((l = descInfo.getServletNamesForServletClass("org.springframework.web.servlet.DispatcherServlet")) == null || l.isEmpty()) {
                return null;
            }
            Map theMap = descInfo.getServletMappings();
            for (String s : l) {
                List ll = (List)theMap.get(s);
                if (ll == null) continue;
                for (String s2 : ll) {
                    if (s2 == null) continue;
                    return s2;
                }
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        return null;
    }

    public static SpringConfigFileInfo parseConfigForServlet(String servletName, String webContentDir) throws IOException, SAXException {
        String filePath = webContentDir + File.separatorChar + "WEB-INF" + File.separatorChar + servletName + "-servlet.xml";
        File contextConfigFile = new File(filePath);
        if (contextConfigFile.exists()) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{filePath}));
            return SpringConfigFileInfo.make((String)filePath);
        }
        return null;
    }

    public static SpringConfigFileInfo parseConfigParamsForServlet(DOMBasedDeploymentDescriptorInfo ddInfo, String servletName, String webContentDir) throws IOException, SAXException {
        List initParamsServlet = ddInfo.getInitParamsForServletName(servletName);
        for (int i = 0; i < initParamsServlet.size(); ++i) {
            String filePath;
            File contextConfigFile;
            if (!((String)((Pair)initParamsServlet.get((int)i)).fst).equals("contextConfigLocation") || !(contextConfigFile = new File(filePath = webContentDir + File.separator + (String)((Pair)initParamsServlet.get((int)i)).snd)).exists()) continue;
            return SpringConfigFileInfo.make((String)filePath);
        }
        return null;
    }
}

