/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringFrameworkHandler;
import com.ibm.appscan.frameworks.handlers.spring3.Spring25HandlerCodeAdapter;
import com.ibm.appscan.frameworks.handlers.spring3.Spring3CallReplacementGenerator;
import com.ibm.appscan.frameworks.handlers.spring3.SpringAnnotationManager;
import com.ibm.appscan.frameworks.handlers.spring3.SpringConfigManager;
import com.ibm.appscan.frameworks.handlers.spring3.WaflGenerator;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.DOMBasedDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.Logger;

public class Spring3Handler
extends F4FHandler {
    public static final String SPRING_DISPATCH_SERVLET_CLASS = "org.springframework.web.servlet.DispatcherServlet";
    private static final Logger logger = TaintLogger.i().getLogger();
    private SpringConfigManager configManager;
    private SpringFrameworkHandler spring25frameworkHandler;

    public void handleApp(F4FApp app, F4FActions actions) {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"SPRING3", "handleApp()"}));
        try {
            float springVersionNum;
            if (this.configManager.getWebXmlFile() != null && this.configManager.getWebXmlFile().trim().length() != 0) {
                this.configManager.findAndParseConfigFiles();
            }
            this.configManager.findAndParseConfigFiles(app);
            if (!this.configManager.isSpringApp()) {
                // empty if block
            }
            if ((double)(springVersionNum = this.configManager.getVersionNumber()) < 3.0 && springVersionNum >= 0.0f) {
                return;
            }
            ArrayList<SpringConfigFileInfo> allConfigInfo = new ArrayList<SpringConfigFileInfo>();
            SpringConfigFileInfo configInfo = null;
            ArrayList<String> dispatcherServlets = this.configManager.getDispatcherServletsThroughApp();
            for (String servletName : dispatcherServlets) {
                block19: {
                    System.out.println("servletName = " + servletName);
                    try {
                        configInfo = Spring25HandlerCodeAdapter.parseConfigForServlet(servletName, this.configManager.getWebContentDir());
                        if (configInfo == null) {
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                        logger.warn((Object)Messages.getString((String)"framework.parse.configuration", (Object[])new Object[]{servletName}));
                    }
                    continue;
                }
                allConfigInfo.add(configInfo);
                this.configManager.getBeanAndValidatorManager().addSpring25BeanInfoList(configInfo.getAllBeanInfo());
            }
            if (this.configManager.getWebXmlFile() != null && this.configManager.getWebXmlFile().trim().length() != 0) {
                DOMBasedDeploymentDescriptorInfo ddInfo = Spring25HandlerCodeAdapter.createDeploymentDescriptorInfo(this.configManager.getWebXmlFile());
                this.spring25frameworkHandler = new SpringFrameworkHandler();
                List contextConfigFileInfo = this.spring25frameworkHandler.getContextConfigFileInfo((IJavaEEDeploymentDescriptorInfo)ddInfo, this.configManager.getWebContentDir());
                allConfigInfo.addAll(contextConfigFileInfo);
                for (String servletName : ddInfo.getServletNamesForServletClass(SPRING_DISPATCH_SERVLET_CLASS)) {
                    block20: {
                        System.out.println("servletName = " + servletName);
                        try {
                            configInfo = Spring25HandlerCodeAdapter.parseConfigForServlet(servletName, this.configManager.getWebContentDir());
                            if (configInfo == null) {
                                configInfo = Spring25HandlerCodeAdapter.parseConfigParamsForServlet(ddInfo, servletName, this.configManager.getWebContentDir());
                            }
                            if (configInfo == null) {
                            }
                            break block20;
                        }
                        catch (Exception e) {
                            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
                            logger.warn((Object)Messages.getString((String)"framework.parse.configuration", (Object[])new Object[]{servletName}));
                        }
                        continue;
                    }
                    allConfigInfo.add(configInfo);
                    this.configManager.getBeanAndValidatorManager().addSpring25BeanInfoList(configInfo.getAllBeanInfo());
                }
                String contextConfigFileName = ddInfo.getContextParamValue("contextConfigLocation");
                if (contextConfigFileName != null) {
                    String[] fileNames = contextConfigFileName.contains(",") ? contextConfigFileName.split(",") : (contextConfigFileName.contains(" ") ? contextConfigFileName.split("\\s") : new String[]{contextConfigFileName});
                    for (int index = 0; index < fileNames.length; ++index) {
                        String currFileName = fileNames[index];
                        if ((currFileName = currFileName.replaceAll("\\s", "")).equals("")) continue;
                        String fullContextConfigFilePath = this.configManager.getWebContentDir() + File.separator + currFileName;
                        System.out.println("fullContextConfigFilePath = " + fullContextConfigFilePath);
                        fullContextConfigFilePath = fullContextConfigFilePath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
                        System.out.println("fullContextConfigFilePath = " + fullContextConfigFilePath);
                        configInfo = SpringConfigFileInfo.make((String)fullContextConfigFilePath);
                        if (allConfigInfo != null) {
                            allConfigInfo.add(configInfo);
                        }
                        this.configManager.getBeanAndValidatorManager().addSpring25BeanInfoList(configInfo.getAllBeanInfo());
                    }
                }
            }
            SpringAppConfigInfo spring25AppConfigInfo = null;
            if (allConfigInfo != null) {
                spring25AppConfigInfo = new SpringAppConfigInfo(allConfigInfo);
                this.configManager.set25AppConfigInfo(spring25AppConfigInfo);
            }
            SpringAnnotationManager springAnnotationManager = new SpringAnnotationManager(app, this.configManager);
            springAnnotationManager.populateBeansFromAnnotations();
            springAnnotationManager.populateValidatorsFromAnnotations();
            WaflGenerator waflGenerator = new WaflGenerator(app, actions, this.configManager);
            waflGenerator.processControllerEntryPoints();
            Spring3CallReplacementGenerator callReplacementGenerator = new Spring3CallReplacementGenerator(app, actions, this.configManager);
            callReplacementGenerator.generateCallReplacements();
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"SPRING3"}));
    }

    public boolean isApplicable() {
        try {
            String webXmlFileName;
            File webXmlFile;
            logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"SPRING3", "isApplicable()"}));
            FrameworksInput frameworksInput = this.getFrameworksInput();
            if (!frameworksInput.getType().equalsIgnoreCase("Java")) {
                return false;
            }
            String webContentDirName = super.getFrameworksInput().getFileLocs().getWebContentDir();
            String scopeFileName = super.getFrameworksInput().getFileLocs().getScopeFileName();
            File webContentDir = new File(webContentDirName);
            if (!webContentDir.exists()) {
                logger.info((Object)Messages.getString((String)"framework.missing.folder", (Object[])new Object[]{webContentDir.getCanonicalPath()}));
                logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
                logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"SPRING3"}));
            }
            if (!(webXmlFile = new File(webXmlFileName = webContentDirName + File.separator + "WEB-INF" + File.separator + "web.xml")).exists()) {
                Iterator iter = FileUtils.iterateFiles((File)webContentDir, (IOFileFilter)new NameFileFilter("web.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
                if (iter.hasNext()) {
                    webXmlFile = (File)iter.next();
                } else {
                    logger.info((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{webXmlFile.getCanonicalPath()}));
                    if (this.configManager == null) {
                        this.configManager = new SpringConfigManager(webContentDirName, null, frameworksInput.getOptions(), scopeFileName);
                    }
                    return true;
                }
            }
            if (this.configManager == null) {
                this.configManager = new SpringConfigManager(webContentDirName, webXmlFileName, frameworksInput.getOptions(), scopeFileName);
            }
            if (frameworksInput.getType().equals("Java")) {
                logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
                return true;
            }
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            logger.warn((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.warn((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"SPRING3"}));
            return false;
        }
    }
}

