/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.handlers.spring3.Spring3BeanInfo;
import com.ibm.appscan.frameworks.handlers.spring3.SpringBeanScope;
import com.ibm.appscan.frameworks.handlers.spring3.SpringConfigManager;
import com.ibm.appscan.frameworks.handlers.spring3.SpringValidator;
import com.ibm.appscan.frameworks.handlers.spring3.Util;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;

public class SpringAnnotationManager {
    private F4FApp f4fApp;
    private SpringConfigManager configManager;

    public SpringAnnotationManager(F4FApp app, SpringConfigManager configManager) {
        this.f4fApp = app;
        this.configManager = configManager;
    }

    public void populateBeansFromAnnotations() {
        if (!this.configManager.isAutoBeanDiscoveryEnabled()) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.failure.unrecognized", (Object[])new Object[]{"annotations"}));
            return;
        }
        try {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"beans using annotations"}));
            Collection theClasses = this.f4fApp.getAllApplicationClasses();
            for (IClass currentClass : theClasses) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{currentClass.getName().toString()}));
                Collection classAnnotations = this.f4fApp.getClassAnnotations(currentClass);
                if (classAnnotations.isEmpty()) continue;
                String beanName = null;
                SpringBeanScope beanScope = null;
                boolean isController = false;
                boolean isEntryPoint = false;
                boolean isRestController = false;
                String theControllerURL = null;
                for (Annotation annot : classAnnotations) {
                    String theAnnotTypeName = annot.getType().toString();
                    if (theAnnotTypeName.contains("javax/inject/Named")) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{theAnnotTypeName}));
                        if (annot.getNamedArguments().size() == 0 || annot.getNamedArguments().get("value") == null) continue;
                        beanName = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString();
                        continue;
                    }
                    if (theAnnotTypeName.contains("Component") || theAnnotTypeName.contains("Repository") || theAnnotTypeName.contains("Service") || theAnnotTypeName.contains("Bean")) continue;
                    if (theAnnotTypeName.contains("Controller")) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{theAnnotTypeName}));
                        isController = true;
                        if (!theAnnotTypeName.contains("RestController")) continue;
                        isRestController = true;
                        continue;
                    }
                    if (theAnnotTypeName.contains("RequestMapping")) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{theAnnotTypeName}));
                        isEntryPoint = true;
                        if (annot.getNamedArguments().get("value") == null) continue;
                        theControllerURL = Util.cleanString(((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString());
                        continue;
                    }
                    if (!theAnnotTypeName.contains("Scope")) continue;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{theAnnotTypeName}));
                    beanScope = this.getBeanScopeFromAnnotation(theAnnotTypeName);
                }
                if (beanName == null) {
                    beanName = currentClass.getName().toString();
                    beanName = beanName.replace("/", ".").substring(1);
                }
                if (beanScope == null) {
                    beanScope = SpringBeanScope.Singleton;
                }
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.bean.found", (Object[])new Object[]{"name=" + beanName + " class=" + currentClass.getName().toString() + " scope=" + beanScope.name().toString()}));
                Spring3BeanInfo bean = new Spring3BeanInfo(beanName, currentClass, beanScope, isController, isRestController, isEntryPoint, theControllerURL);
                this.configManager.getBeanAndValidatorManager().addBean(bean);
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private SpringBeanScope getBeanScopeFromAnnotation(String annotationStr) {
        SpringBeanScope beanScope = null;
        if (annotationStr.contains("singleton")) {
            beanScope = SpringBeanScope.Singleton;
        } else if (annotationStr.contains("prototype")) {
            beanScope = SpringBeanScope.Prototype;
        } else if (annotationStr.contains("request")) {
            beanScope = SpringBeanScope.Request;
        } else if (annotationStr.contains("session")) {
            beanScope = SpringBeanScope.Session;
        } else if (annotationStr.contains("globalSession")) {
            beanScope = SpringBeanScope.GlobalSession;
        } else {
            beanScope = SpringBeanScope.Singleton;
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.unknown.scope", (Object[])new Object[]{annotationStr}));
        }
        return beanScope;
    }

    public void populateValidatorsFromAnnotations() {
        if (!this.configManager.isJSR303BeanValidatorEnabled()) {
            return;
        }
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"validators using annotations"}));
        Collection clazzFields = new ArrayList();
        try {
            Collection theClasses = this.f4fApp.getAllApplicationClasses();
            for (IClass currentClass : theClasses) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{currentClass.getName().toString()}));
                clazzFields.clear();
                clazzFields = currentClass.getAllFields();
                for (IField currentField : clazzFields) {
                    Collection fieldAnnotations = this.f4fApp.getFieldAnnotations(currentField);
                    if (fieldAnnotations == null) continue;
                    Enum validatorType = null;
                    String validatorParam = null;
                    for (Annotation annot : fieldAnnotations) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{annot.getType().toString()}));
                        if (annot.getType().toString().contains("NotEmpty")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_NOTEMPTY;
                            continue;
                        }
                        if (annot.getType().toString().contains("NotNull")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_NOTNULL;
                            continue;
                        }
                        if (annot.getType().toString().contains("Range")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_RANGE;
                            continue;
                        }
                        if (annot.getType().toString().contains("Max")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_MAX;
                            if (annot.getNamedArguments().size() != 0) {
                                validatorParam = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString();
                                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"value=" + validatorParam}));
                                continue;
                            }
                            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{validatorType.name()}));
                            continue;
                        }
                        if (annot.getType().toString().contains("Min")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_MIN;
                            if (annot.getNamedArguments().size() != 0) {
                                validatorParam = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString();
                                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"value=" + validatorParam}));
                                continue;
                            }
                            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{validatorType.name()}));
                            continue;
                        }
                        if (annot.getType().toString().contains("Size")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_SIZE;
                            if (annot.getNamedArguments().size() != 0) {
                                if (annot.getNamedArguments().get("max") != null) {
                                    validatorParam = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("max")).toString();
                                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"max=" + validatorParam}));
                                    continue;
                                }
                                if (annot.getNamedArguments().get("min") != null) {
                                    validatorParam = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("min")).toString();
                                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"min=" + validatorParam}));
                                    continue;
                                }
                                if (annot.getNamedArguments().get("message") != null) {
                                    validatorParam = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("message")).toString();
                                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"message=" + validatorParam}));
                                    continue;
                                }
                                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{validatorType.name()}));
                                continue;
                            }
                            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{validatorType.name()}));
                            continue;
                        }
                        if (annot.getType().toString().contains("NumberFormat")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                            validatorType = SpringValidator.SpringValidatorType.VALIDATOR_NUMBERFORMAT;
                            continue;
                        }
                        if (!annot.getType().toString().contains("Valid")) continue;
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                        validatorType = SpringValidator.SpringValidatorType.VALIDATOR_VALID;
                    }
                    if (validatorType == null) continue;
                    SpringValidator validator = new SpringValidator((SpringValidator.SpringValidatorType)validatorType, validatorParam, currentField, currentClass);
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.validator.found", (Object[])new Object[]{"type=" + validatorType.name()}));
                    this.configManager.getBeanAndValidatorManager().addValidator(validator);
                }
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }
}

