/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.loader;

import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.java.loader.Util;
import com.ibm.wala.cast.java.ssa.AstJavaInstructionFactory;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.AstJavaNewEnclosingInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.loader.AstClass;
import com.ibm.wala.cast.loader.AstField;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstAnnotation;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JavaSourceLoaderImpl
extends ClassLoaderImpl {
    public Map<CAstEntity, IClass> fTypeMap = HashMapFactory.make();
    private final boolean existsCommonSuperclass;
    public static volatile boolean deleteTypeMapAfterInit = true;
    private static final InstructionFactory insts = new InstructionFactory();

    private Collection<Annotation> getAnnotations(CAstEntity e) {
        Collection annotations = e.getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        HashSet result = HashSetFactory.make();
        for (CAstAnnotation ca : annotations) {
            TypeName walaTypeName = this.toWALATypeName(ca.getType());
            TypeReference ref = TypeReference.findOrCreate((ClassLoaderReference)this.getReference(), (TypeName)walaTypeName);
            if (ca.getArguments() == null || ca.getArguments().isEmpty()) {
                result.add(Annotation.make((TypeReference)ref));
                continue;
            }
            HashMap args = HashMapFactory.make();
            for (Map.Entry a : ca.getArguments().entrySet()) {
                args.put(a.getKey(), new AnnotationsReader.ConstantElementValue(a.getValue()));
            }
            result.add(Annotation.makeWithNamed((TypeReference)ref, (Map)args));
        }
        return result;
    }

    public static int mapToInt(Collection qualifiers) {
        int result = 0;
        for (CAstQualifier q : qualifiers) {
            if (q == CAstQualifier.PUBLIC) {
                result |= 1;
            }
            if (q == CAstQualifier.PROTECTED) {
                result |= 4;
            }
            if (q == CAstQualifier.PRIVATE) {
                result |= 2;
            }
            if (q == CAstQualifier.STATIC) {
                result |= 8;
            }
            if (q == CAstQualifier.FINAL) {
                result |= 0x10;
            }
            if (q == CAstQualifier.SYNCHRONIZED) {
                result |= 0x20;
            }
            if (q == CAstQualifier.TRANSIENT) {
                result |= 0x80;
            }
            if (q == CAstQualifier.NATIVE) {
                result |= 0x100;
            }
            if (q == CAstQualifier.INTERFACE) {
                result |= 0x200;
            }
            if (q == CAstQualifier.ABSTRACT) {
                result |= 0x400;
            }
            if (q == CAstQualifier.VOLATILE) {
                result |= 0x40;
            }
            if (q != CAstQualifier.STRICTFP) continue;
            result |= 0x800;
        }
        return result;
    }

    public JavaSourceLoaderImpl(boolean existsCommonSuperClass, ClassLoaderReference loaderRef, IClassLoader parent, SetOfClasses exclusions, IClassHierarchy cha) throws IOException {
        super(loaderRef, cha.getScope().getArrayClassLoader(), parent, cha.getScope().getExclusions(), cha);
        this.existsCommonSuperclass = existsCommonSuperClass;
    }

    public JavaSourceLoaderImpl(ClassLoaderReference loaderRef, IClassLoader parent, SetOfClasses exclusions, IClassHierarchy cha) throws IOException {
        this(true, loaderRef, parent, exclusions, cha);
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    protected void loadAllSources(Set<ModuleEntry> modules) {
        this.getTranslator().loadAllSources(modules);
    }

    protected abstract SourceModuleTranslator getTranslator();

    public void init(List<Module> modules) throws IOException {
        super.init(modules);
        if (deleteTypeMapAfterInit) {
            this.fTypeMap = null;
        }
    }

    public void defineFunction(CAstEntity n, IClass owner, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
        ((JavaClass)owner).addMethod(n, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
    }

    public void defineAbstractFunction(CAstEntity n, IClass owner) {
        ((JavaClass)owner).addMethod(n, owner);
    }

    public void defineField(CAstEntity n, IClass owner) {
        ((JavaClass)owner).addField(n);
    }

    private TypeName toWALATypeName(CAstType type) {
        return TypeName.string2TypeName((String)type.getName());
    }

    public IClass defineType(CAstEntity type, String typeName, CAstEntity owner) {
        ArrayList<TypeName> superTypeNames = new ArrayList<TypeName>();
        Iterator superTypes = type.getType().getSupertypes().iterator();
        while (superTypes.hasNext()) {
            superTypeNames.add(this.toWALATypeName((CAstType)superTypes.next()));
        }
        JavaClass javaClass = new JavaClass(typeName, superTypeNames, type.getPosition(), type.getQualifiers(), this, (IClass)(owner != null ? (JavaClass)this.fTypeMap.get(owner) : (JavaClass)null), this.getAnnotations(type));
        if (this.getParent().lookupClass(javaClass.getName()) != null) {
            return null;
        }
        this.fTypeMap.put(type, (IClass)javaClass);
        this.loadedClasses.put(javaClass.getName(), javaClass);
        return javaClass;
    }

    public String toString() {
        return "Java Source Loader (classes " + this.loadedClasses.values() + ")";
    }

    public InstructionFactory getInstructionFactory() {
        return insts;
    }

    public static class InstructionFactory
    extends JavaLanguage.JavaInstructionFactory
    implements AstJavaInstructionFactory {
        @Override
        public EnclosingObjectReference EnclosingObjectReference(int iindex, int lval, TypeReference type) {
            return new EnclosingObjectReference(iindex, lval, type);
        }

        @Override
        public AstJavaNewEnclosingInstruction JavaNewEnclosingInstruction(int iindex, int result, NewSiteReference site, int enclosing) {
            return new AstJavaNewEnclosingInstruction(iindex, result, site, enclosing);
        }

        @Override
        public AstJavaInvokeInstruction JavaInvokeInstruction(int iindex, int[] result, int[] params, int exception, CallSiteReference site) {
            return result == null ? new AstJavaInvokeInstruction(iindex, params, exception, site) : new AstJavaInvokeInstruction(iindex, result[0], params, exception, site);
        }

        public AstAssertInstruction AssertInstruction(int iindex, int value, boolean fromSpecification) {
            return new AstAssertInstruction(iindex, value, fromSpecification);
        }

        public AssignInstruction AssignInstruction(int iindex, int result, int val) {
            return new AssignInstruction(iindex, result, val);
        }

        public EachElementGetInstruction EachElementGetInstruction(int iindex, int value, int objectRef, int propRef) {
            throw new UnsupportedOperationException();
        }

        public EachElementHasNextInstruction EachElementHasNextInstruction(int iindex, int value, int objectRef, int propRef) {
            throw new UnsupportedOperationException();
        }

        public AstEchoInstruction EchoInstruction(int iindex, int[] rvals) {
            throw new UnsupportedOperationException();
        }

        public AstGlobalRead GlobalRead(int iindex, int lhs, FieldReference global) {
            throw new UnsupportedOperationException();
        }

        public AstGlobalWrite GlobalWrite(int iindex, FieldReference global, int rhs) {
            throw new UnsupportedOperationException();
        }

        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal, FieldReference fieldRef) {
            throw new UnsupportedOperationException();
        }

        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, FieldReference fieldRef) {
            throw new UnsupportedOperationException();
        }

        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal) {
            throw new UnsupportedOperationException();
        }

        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval) {
            throw new UnsupportedOperationException();
        }

        public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access[] accesses) {
            return new AstLexicalRead(iindex, accesses);
        }

        public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access access) {
            return new AstLexicalRead(iindex, access);
        }

        public AstLexicalRead LexicalRead(int iindex, int lhs, String definer, String globalName, TypeReference type) {
            return new AstLexicalRead(iindex, lhs, definer, globalName, type);
        }

        public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access[] accesses) {
            return new AstLexicalWrite(iindex, accesses);
        }

        public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access access) {
            return new AstLexicalWrite(iindex, access);
        }

        public AstLexicalWrite LexicalWrite(int iindex, String definer, String globalName, TypeReference type, int rhs) {
            return new AstLexicalWrite(iindex, definer, globalName, type, rhs);
        }

        public SSAThrowInstruction NonExceptingThrowInstruction(int iindex, int exception) {
            throw new UnsupportedOperationException();
        }
    }

    public class ConcreteJavaMethod
    extends JavaEntityMethod {
        public ConcreteJavaMethod(CAstEntity methodEntity, IClass owner, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            super(methodEntity, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaSourceLoaderImpl.this.cha;
        }

        public String getLocalVariableName(int bcIndex, int localNumber) {
            return null;
        }

        public boolean hasLocalVariableTable() {
            return false;
        }

        public AstMethod.LexicalParent[] getParents() {
            if (this.lexicalInfo() == null) {
                return new AstMethod.LexicalParent[0];
            }
            final String[] parents = this.lexicalInfo().getScopingParents();
            if (parents == null) {
                return new AstMethod.LexicalParent[0];
            }
            AstMethod.LexicalParent[] result = new AstMethod.LexicalParent[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                int lastLeftParen = parents[i].lastIndexOf(40);
                int lastQ = parents[i].lastIndexOf(47, lastLeftParen);
                String typeName = parents[i].substring(0, lastQ);
                final IClass cls = JavaSourceLoaderImpl.this.lookupClass(TypeName.string2TypeName((String)typeName));
                String sig = parents[i].substring(lastQ);
                int nameEnd = sig.indexOf(40);
                String nameStr = sig.substring(1, nameEnd);
                Atom name = Atom.findOrCreateUnicodeAtom((String)nameStr);
                String descStr = sig.substring(nameEnd);
                Descriptor desc = Descriptor.findOrCreateUTF8((Language)Language.JAVA, (String)descStr);
                final Selector sel = new Selector(name, desc);
                final int hack = i;
                result[i] = new AstMethod.LexicalParent(){

                    public String getName() {
                        return parents[hack];
                    }

                    public AstMethod getMethod() {
                        return (AstMethod)cls.getMethod(sel);
                    }
                };
            }
            return result;
        }
    }

    private class AbstractJavaMethod
    extends JavaEntityMethod {
        public AbstractJavaMethod(CAstEntity methodEntity, IClass owner) {
            super(methodEntity, owner);
        }

        public String getLocalVariableName(int bcIndex, int localNumber) {
            Assertions.UNREACHABLE((String)"AbstractJavaMethod.getLocalVariableName() called");
            return null;
        }

        public boolean hasLocalVariableTable() {
            Assertions.UNREACHABLE((String)"AbstractJavaMethod.hasLocalVariableTable() called");
            return false;
        }

        public AstMethod.LexicalParent[] getParents() {
            return new AstMethod.LexicalParent[0];
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaSourceLoaderImpl.this.cha;
        }
    }

    private abstract class JavaEntityMethod
    extends AstMethod {
        private final TypeReference[] parameterTypes;
        private final TypeReference[] exceptionTypes;

        public JavaEntityMethod(CAstEntity methodEntity, IClass owner, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            super(owner, methodEntity.getQualifiers(), cfg, symtab, MethodReference.findOrCreate((TypeReference)owner.getReference(), (Selector)Util.methodEntityToSelector(methodEntity)), hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo, JavaSourceLoaderImpl.this.getAnnotations(methodEntity));
            this.parameterTypes = this.computeParameterTypes(methodEntity);
            this.exceptionTypes = this.computeExceptionTypes(methodEntity);
        }

        public JavaEntityMethod(CAstEntity methodEntity, IClass owner) {
            super(owner, methodEntity.getQualifiers(), MethodReference.findOrCreate((TypeReference)owner.getReference(), (Selector)Util.methodEntityToSelector(methodEntity)), JavaSourceLoaderImpl.this.getAnnotations(methodEntity));
            this.parameterTypes = this.computeParameterTypes(methodEntity);
            this.exceptionTypes = this.computeExceptionTypes(methodEntity);
        }

        public int getMaxLocals() {
            Assertions.UNREACHABLE((String)"AbstractJavaMethod.getMaxLocals() called");
            return 0;
        }

        public int getMaxStackHeight() {
            Assertions.UNREACHABLE((String)"AbstractJavaMethod.getMaxStackHeight() called");
            return 0;
        }

        public TypeReference getParameterType(int i) {
            return this.parameterTypes[i];
        }

        private TypeReference[] computeParameterTypes(CAstEntity methodEntity) {
            TypeReference[] types;
            CAstType.Function type = (CAstType.Function)methodEntity.getType();
            int argCount = type.getArgumentTypes().size();
            if (this.isStatic()) {
                types = new TypeReference[argCount];
                for (int i = 0; i < argCount; ++i) {
                    types[i] = TypeReference.findOrCreate((ClassLoaderReference)JavaSourceLoaderImpl.this.getReference(), (String)((CAstType)type.getArgumentTypes().get(i)).getName());
                }
            } else {
                types = new TypeReference[argCount + 1];
                types[0] = this.cls.getReference();
                for (int i = 0; i < argCount; ++i) {
                    types[i + 1] = TypeReference.findOrCreate((ClassLoaderReference)JavaSourceLoaderImpl.this.getReference(), (String)((CAstType)type.getArgumentTypes().get(i)).getName());
                }
            }
            return types;
        }

        public TypeReference[] getDeclaredExceptions() {
            return this.exceptionTypes;
        }

        private TypeReference[] computeExceptionTypes(CAstEntity methodEntity) {
            CAstType.Function fType = (CAstType.Function)methodEntity.getType();
            Collection exceptionTypes = fType.getExceptionTypes();
            TypeReference[] result = new TypeReference[exceptionTypes.size()];
            int i = 0;
            for (CAstType type : exceptionTypes) {
                result[i] = TypeReference.findOrCreate((ClassLoaderReference)JavaSourceLoaderImpl.this.getReference(), (String)type.getName());
                ++i;
            }
            return result;
        }

        public String toString() {
            return "<src-method: " + this.getReference() + ">";
        }
    }

    private class JavaField
    extends AstField {
        private JavaField(CAstEntity fieldEntity, IClassLoader loader, IClass declaringClass, Collection<Annotation> annotations) {
            super(FieldReference.findOrCreate((TypeReference)declaringClass.getReference(), (Atom)Atom.findOrCreateUnicodeAtom((String)fieldEntity.getName()), (TypeReference)TypeReference.findOrCreate((ClassLoaderReference)loader.getReference(), (TypeName)TypeName.string2TypeName((String)fieldEntity.getType().getName()))), fieldEntity.getQualifiers(), declaringClass, declaringClass.getClassHierarchy(), annotations);
        }
    }

    public class JavaClass
    extends AstClass {
        protected final IClass enclosingClass;
        protected final Collection superTypeNames;
        private final Collection<Annotation> annotations;

        public JavaClass(String typeName, Collection superTypeNames, CAstSourcePositionMap.Position position, Collection qualifiers, JavaSourceLoaderImpl loader, IClass enclosingClass, Collection<Annotation> annotations) {
            super(position, TypeName.string2TypeName((String)typeName), (IClassLoader)loader, (short)JavaSourceLoaderImpl.mapToInt(qualifiers), new HashMap(), new HashMap());
            this.superTypeNames = superTypeNames;
            this.enclosingClass = enclosingClass;
            this.annotations = annotations;
        }

        public Collection<Annotation> getAnnotations() {
            return this.annotations;
        }

        public IClassHierarchy getClassHierarchy() {
            return JavaSourceLoaderImpl.this.cha;
        }

        public IClass getSuperclass() {
            boolean excludedSupertype = false;
            for (TypeName name : this.superTypeNames) {
                IClass domoType = JavaSourceLoaderImpl.this.lookupClass(name);
                if (domoType != null && !domoType.isInterface()) {
                    return domoType;
                }
                if (domoType != null || !this.getClassHierarchy().getScope().getExclusions().contains(name.toString().substring(1))) continue;
                excludedSupertype = true;
            }
            if (JavaSourceLoaderImpl.this.existsCommonSuperclass && !this.getName().equals((Object)JavaSourceLoaderImpl.this.getLanguage().getRootType().getName()) && !excludedSupertype) {
                Assertions.UNREACHABLE((String)("Cannot find super class for " + (Object)((Object)this) + " in " + this.superTypeNames));
            }
            if (excludedSupertype) {
                System.err.println("Not tracking calls through excluded superclass of " + this.getName() + " extends " + this.superTypeNames);
            }
            return null;
        }

        public Collection<IClass> getDirectInterfaces() {
            ArrayList<IClass> result = new ArrayList<IClass>();
            for (TypeName name : this.superTypeNames) {
                IClass domoType = JavaSourceLoaderImpl.this.lookupClass(name);
                if (domoType != null && domoType.isInterface()) {
                    result.add(domoType);
                }
                if (domoType == null && !this.getClassHierarchy().getScope().getExclusions().contains(name.toString().substring(1))) assert (false) : "Failed to find non-excluded interface: " + name;
            }
            return result;
        }

        private void addMethod(CAstEntity methodEntity, IClass owner, AbstractCFG cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            this.declaredMethods.put(Util.methodEntityToSelector(methodEntity), new ConcreteJavaMethod(methodEntity, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo));
        }

        private void addMethod(CAstEntity methodEntity, IClass owner) {
            this.declaredMethods.put(Util.methodEntityToSelector(methodEntity), new AbstractJavaMethod(methodEntity, owner));
        }

        private void addField(CAstEntity fieldEntity) {
            this.declaredFields.put(Util.fieldEntityToAtom(fieldEntity), new JavaField(fieldEntity, (IClassLoader)JavaSourceLoaderImpl.this, (IClass)this, JavaSourceLoaderImpl.this.getAnnotations(fieldEntity)));
        }

        public IClass getEnclosingClass() {
            return this.enclosingClass;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("<src-class: ");
            sb.append(this.getName().toString());
            if (this.enclosingClass != null) {
                sb.append(" (within " + this.enclosingClass.getName() + ")");
            }
            if (this.annotations != null && !this.annotations.isEmpty()) {
                for (Annotation a : this.annotations) {
                    sb.append("[" + a.getType().getName().getClassName() + "]");
                }
            }
            return sb.toString();
        }
    }
}

