/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.BuiltInValidators;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfInfoManager;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfNodeInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.ManagedBean;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;

public class Validator {
    private ValidatorType m_type;
    private String m_validatorId;
    private String m_beanName;
    private String m_validatorClassName;
    private String m_beanValidatorMethodName;
    private FilePositionInfo m_filePositioninfo;

    public Validator(ValidatorType type) {
        this.m_type = type;
    }

    public void setValidatorId(String id) {
        assert (this.m_type == ValidatorType.VALIDATOR_CUSTOM);
        this.m_validatorId = id;
    }

    public String getVaildatorId() {
        return this.m_validatorId;
    }

    public String getBeanName() {
        assert (this.m_type == ValidatorType.VALIDATOR_BEAN);
        return this.m_beanName;
    }

    public boolean setNamesForBeanValidator(String validatorStr) {
        int index = validatorStr.lastIndexOf(".");
        if (index == -1 || index == 0) {
            TaintLogger.i().getLogger().warn((Object)("Failure in getting method name from input data description: " + validatorStr));
        }
        if (validatorStr.startsWith("#{") && validatorStr.endsWith("}")) {
            this.m_beanValidatorMethodName = validatorStr.substring(index + 1, validatorStr.length() - 1);
            this.m_beanName = validatorStr.substring(2, index);
            return true;
        }
        TaintLogger.i().getLogger().warn((Object)("Failure in parsing the bean Validator from input data description: " + validatorStr));
        return false;
    }

    public void setValidatorClassName(String className) {
        this.m_validatorClassName = className;
    }

    public void setBeanValidatorMethodName(String beanMethodName) {
        this.m_beanValidatorMethodName = beanMethodName;
    }

    public FilePositionInfo getFilePositioninfo() {
        return this.m_filePositioninfo;
    }

    public void setFilePositioninfo(FilePositionInfo m_filePositioninfo) {
        this.m_filePositioninfo = m_filePositioninfo;
    }

    public void setFilePositioninfo(JsfNodeInfo jsfNodeInfo, String fileName) {
        this.m_filePositioninfo = FilePositionInfo.make((String)fileName, (int)jsfNodeInfo.getLineNumber(), (int)jsfNodeInfo.getColumnNumber());
    }

    public void createWAFL(F4FApp app, F4FActions actions, HighLevelSyntheticMethod synMethod, JsfInfoManager jsfInfoManager, Param beanVar, Param valueToBeValidate) {
        String errorMsg = null;
        try {
            switch (this.m_type) {
                case VALIDATOR_BUILTIN_DOUBLERANGE: {
                    String callSig = BuiltInValidators.getDoubleRangeValidatorVdbSig();
                    if (callSig == null) break;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig}));
                    synMethod.addCall(callSig, this.m_filePositioninfo, new Param[]{null, null, null, valueToBeValidate});
                    return;
                }
                case VALIDATOR_BUILTIN_LENGTH: {
                    String callSig = BuiltInValidators.getLengthValidatorVdbSig();
                    if (callSig == null) break;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig}));
                    synMethod.addCall(callSig, this.m_filePositioninfo, new Param[]{null, null, null, valueToBeValidate});
                    return;
                }
                case VALIDATOR_BUILTIN_LONGRANGE: {
                    String callSig = BuiltInValidators.getLongRangeValidatorVdbSig();
                    if (callSig == null) break;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig}));
                    synMethod.addCall(callSig, this.m_filePositioninfo, new Param[]{null, null, null, valueToBeValidate});
                    return;
                }
                case VALIDATOR_BUILTIN_REGEX: {
                    String callSig = BuiltInValidators.getregexValidatorVdbSig();
                    if (callSig == null) break;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig}));
                    synMethod.addCall(callSig, this.m_filePositioninfo, new Param[]{null, null, null, valueToBeValidate});
                    return;
                }
                case VALIDATOR_BEAN: {
                    if (this.m_beanName == null) {
                        errorMsg = "Bean name in Validator (type = VALIDATOR_BEAN) is NULL. ";
                        break;
                    }
                    ManagedBean mBean = jsfInfoManager.findBean(this.m_beanName);
                    if (mBean == null) {
                        errorMsg = "Could not find managed bean for Valiator(type = VALIDATOR_BEAN) from faces config files. bean name is '" + this.m_beanName + "' ";
                        break;
                    }
                    IClass beanClass = mBean.getClassType(app);
                    if (beanClass == null) {
                        errorMsg = "Could not find bean class for Valiator(type = VALIDATOR_BEAN) from faces config files. bean name is '" + this.m_beanName + "' ";
                        break;
                    }
                    IMethod validatorMethod = null;
                    for (IMethod currMethod : beanClass.getAllMethods()) {
                        if (!this.m_beanValidatorMethodName.equals(currMethod.getName().toString())) continue;
                        validatorMethod = currMethod;
                        break;
                    }
                    if (validatorMethod != null) {
                        int paramNum = validatorMethod.getNumberOfParameters();
                        Param[] paramsForCall = null;
                        if (paramNum > 0) {
                            paramsForCall = new Param[paramNum];
                            paramsForCall[paramNum - 1] = beanVar;
                        }
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{validatorMethod}));
                        synMethod.addCall(validatorMethod, this.m_filePositioninfo, paramsForCall);
                        return;
                    }
                    errorMsg = "Could not find bean method for Valiator(type = VALIDATOR_BEAN) from bean class.bean class is '" + beanClass.getName().toString() + "'.  bean method is '" + this.m_beanValidatorMethodName + "'. ";
                    break;
                }
                case VALIDATOR_CUSTOM: {
                    this.m_beanValidatorMethodName = "validate";
                    String methodSig = this.m_validatorClassName + ".validate(javax.faces.context.FacesContext;javax.faces.component.UIComponent;java.lang.Object):void";
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{methodSig}));
                    synMethod.addCall(methodSig, this.m_filePositioninfo, new Param[]{null, null, null, beanVar});
                    return;
                }
            }
        }
        catch (Exception e) {
            StringBuilder fileInfoStr = new StringBuilder();
            if (this.m_filePositioninfo != null) {
                fileInfoStr.append(this.m_filePositioninfo.getFilename());
                fileInfoStr.append("  line: ");
                fileInfoStr.append(this.m_filePositioninfo.getLineNumber());
                fileInfoStr.append("  column: ");
                fileInfoStr.append(this.m_filePositioninfo.getLineNumber());
            }
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{"( validatorId = " + this.m_validatorId + " ; validatorClassName = " + this.m_validatorClassName + " ; beanValidatorMethodName = " + this.m_beanValidatorMethodName + "  bean name = " + this.m_beanName + ") while generating validator Method for view page: " + fileInfoStr.toString()}));
        }
        StringBuilder fileInfoStr = new StringBuilder();
        if (this.m_filePositioninfo != null) {
            fileInfoStr.append(this.m_filePositioninfo.getFilename());
            fileInfoStr.append("  line: ");
            fileInfoStr.append(this.m_filePositioninfo.getLineNumber());
            fileInfoStr.append("  column: ");
            fileInfoStr.append(this.m_filePositioninfo.getLineNumber());
        }
        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.validator", (Object[])new Object[]{"( validatorId = " + this.m_validatorId + " ; validatorClassName = " + this.m_validatorClassName + " ; beanValidatorMethodName = " + this.m_beanValidatorMethodName + " ) while generating validator Method for view page : " + fileInfoStr.toString() + ". Error message: " + errorMsg}));
    }

    public static enum ValidatorType {
        VALIDATOR_BUILTIN_DOUBLERANGE,
        VALIDATOR_BUILTIN_LENGTH,
        VALIDATOR_BUILTIN_LONGRANGE,
        VALIDATOR_BUILTIN_REGEX,
        VALIDATOR_BEAN,
        VALIDATOR_CUSTOM;

    }
}

