/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.JSFBeanScope;
import com.ibm.appscan.frameworks.handlers.jsf2.JSFViewInputDataInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.Jsf2GeneralUtil;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfInfoManager;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfNodeInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfViewFileParser;
import com.ibm.appscan.frameworks.handlers.jsf2.ManagedBean;
import com.ibm.appscan.frameworks.handlers.jsf2.NavigationCaseInfo;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.EnclosingFormal;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.util.collections.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ViewWaflGenerator {
    private JsfInfoManager m_jsfInfoManager;
    private JsfViewFileParser m_jsfViewFileInfo;
    private String m_viewFile;
    private Map<String, JsfViewFileParser> m_fileNameToJSFViewMap;
    private List<String> addedCallVdbSigList = new ArrayList<String>();
    F4FApp app;
    F4FActions actions;

    public ViewWaflGenerator(JsfInfoManager jsfInfoManager, JsfViewFileParser jsfViewFileInfo, Map<String, JsfViewFileParser> fileNameToJSFViewMap, String viewFile) {
        this.m_jsfInfoManager = jsfInfoManager;
        this.m_jsfViewFileInfo = jsfViewFileInfo;
        this.m_fileNameToJSFViewMap = fileNameToJSFViewMap;
        this.m_viewFile = viewFile;
    }

    public void generateSynthMethod(F4FApp app, F4FActions actions) {
        this.app = app;
        this.actions = actions;
        try {
            if (this.m_jsfViewFileInfo.getBeanRefInputList().size() == 0 && this.m_jsfViewFileInfo.getActionList().size() == 0 && this.m_jsfViewFileInfo.getBeanRefOutputList().size() == 0 && this.m_jsfInfoManager.findForward(this.m_viewFile).size() == 0) {
                return;
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{this.getVdbSignature(this.m_viewFile)}));
            HighLevelSyntheticMethod synMethod = HighLevelSyntheticMethod.make((String)this.getVdbSignature(this.m_viewFile));
            this.generateCallsFromOutputs(synMethod);
            this.generateCallsFromInputs(synMethod);
            this.generateCallsFromActions(synMethod);
            this.generateCallsToNextViewPage(synMethod);
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{synMethod.getVdbSignature()}));
            actions.addHighLevelSyntheticMethod(synMethod);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private String getVdbSignature(String viewFileName) {
        String methodVdbSig = null;
        String webDirName = this.m_jsfInfoManager.getWebDirectory();
        if (viewFileName.startsWith(webDirName)) {
            String viewSig = viewFileName.substring(webDirName.length()).replace(File.separatorChar, '_').replace('.', '_');
            methodVdbSig = "AppScan.Synthetic.JSF." + viewSig + "(javax.servlet.http.HttpServletRequest;javax.servlet.http.HttpServletResponse):void";
            return methodVdbSig;
        }
        methodVdbSig = "AppScan.Synthetic.JSF.__highLevelSynth__" + viewFileName.replace(File.separatorChar, '_') + "():void";
        return methodVdbSig;
    }

    private void generateCallsToNextViewPage(HighLevelSyntheticMethod synMethod) {
        try {
            List<NavigationCaseInfo> viewForwards = this.m_jsfInfoManager.findForward(this.m_viewFile);
            if (viewForwards.size() > 0) {
                for (NavigationCaseInfo currForwardInfo : viewForwards) {
                    String vdbSig;
                    JsfViewFileParser viewFileInfo;
                    if (currForwardInfo.getToViewId().equals(this.m_viewFile) || (viewFileInfo = this.m_fileNameToJSFViewMap.get(currForwardInfo.getToViewId())).isEmpty(this.m_jsfInfoManager) || this.addedCallVdbSigList.contains(vdbSig = this.getVdbSignature(currForwardInfo.getToViewId()))) continue;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{vdbSig}));
                    synMethod.addCall(vdbSig, currForwardInfo.getFilePositionInfo(), new Param[]{EnclosingFormal.FIRST, EnclosingFormal.SECOND});
                    this.addedCallVdbSigList.add(vdbSig);
                }
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void generateCallsFromActions(HighLevelSyntheticMethod synMethod) {
        List<Pair<String, JsfNodeInfo>> actionList = this.m_jsfViewFileInfo.getActionList();
        try {
            if (actionList.size() > 0) {
                for (Pair<String, JsfNodeInfo> pair : actionList) {
                    String actionStr = (String)pair.fst;
                    if (!this.isBeanReference(actionStr)) {
                        String vdbSig;
                        String forwardViewFileName = this.getMappingViewFileName(actionStr);
                        if (forwardViewFileName == null || this.addedCallVdbSigList.contains(vdbSig = this.getVdbSignature(forwardViewFileName))) continue;
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{vdbSig}));
                        synMethod.addCall(vdbSig, FilePositionInfo.make((String)this.m_viewFile, (int)((JsfNodeInfo)pair.snd).getLineNumber(), (int)((JsfNodeInfo)pair.snd).getColumnNumber()), new Param[]{EnclosingFormal.FIRST, EnclosingFormal.SECOND});
                        this.addedCallVdbSigList.add(vdbSig);
                        continue;
                    }
                    String beanName = this.getBeanNameFromBeanRefStr(actionStr);
                    String[] methodNames = this.getMethodOrFieldNamesFromBeanRefStr(actionStr);
                    if (beanName == null || methodNames.length == 0) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{actionStr}));
                        continue;
                    }
                    String methodName = methodNames[0];
                    ManagedBean bean = this.m_jsfInfoManager.findBean(beanName);
                    if (bean == null) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{actionStr}));
                        continue;
                    }
                    IClass beanClass = bean.getClassType(this.app);
                    if (beanClass == null) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{actionStr}));
                        continue;
                    }
                    Param global = this.getVariable(bean, synMethod);
                    IMethod actionMethod = this.getMethod(beanClass, methodName);
                    if (actionMethod == null) continue;
                    JsfNodeInfo nodeInfo = (JsfNodeInfo)pair.snd;
                    int paramNum = actionMethod.getNumberOfParameters();
                    Param[] paramsForCall = null;
                    if (paramNum > 0) {
                        paramsForCall = new Param[paramNum];
                        paramsForCall[0] = global;
                    }
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{actionMethod}));
                    synMethod.addCall(actionMethod, FilePositionInfo.make((String)this.m_viewFile, (int)nodeInfo.getLineNumber(), (int)nodeInfo.getColumnNumber()), paramsForCall);
                }
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void generateCallsFromOutputs(HighLevelSyntheticMethod synMethod) {
        try {
            List<Pair<String, JsfNodeInfo>> beanRefOutputList = this.m_jsfViewFileInfo.getBeanRefOutputList();
            if (beanRefOutputList.size() > 0) {
                for (Pair<String, JsfNodeInfo> pair : beanRefOutputList) {
                    String outputStr = (String)pair.fst;
                    String beanName = this.getBeanNameFromBeanRefStr(outputStr);
                    String[] propertyNames = this.getMethodOrFieldNamesFromBeanRefStr(outputStr);
                    if (beanName == null || propertyNames.length == 0) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{outputStr}));
                        continue;
                    }
                    String propertyName = propertyNames[0];
                    ManagedBean bean = this.m_jsfInfoManager.findBean(beanName);
                    if (bean == null) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{outputStr}));
                        continue;
                    }
                    IClass beanClass = bean.getClassType(this.app);
                    if (beanClass == null) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{outputStr}));
                        continue;
                    }
                    Param global = this.getVariable(bean, synMethod);
                    String getterMethodName = this.getGetterMethodName(propertyName);
                    IMethod getterMethod = this.getMethod(beanClass, getterMethodName);
                    if (getterMethod == null) continue;
                    JsfNodeInfo nodeInfo = (JsfNodeInfo)pair.snd;
                    FilePositionInfo filePositionInfo = FilePositionInfo.make((String)this.m_viewFile, (int)nodeInfo.getLineNumber(), (int)nodeInfo.getColumnNumber());
                    Local retValue = synMethod.addCall(getterMethod, filePositionInfo, new Param[]{global});
                    if (propertyNames.length > 1) {
                        for (int idx = 1; idx < propertyNames.length; ++idx) {
                            String currGetMethodName;
                            IMethod currgetterMethod;
                            if (propertyNames[idx].equals("")) continue;
                            String getterMethodVdbSig = getterMethod.getReturnType().getName().toString();
                            IClass currClass = this.app.getIClass(VDBJavaUtil.jvmToVDBType((String)getterMethodVdbSig));
                            if (currClass == null || (currgetterMethod = this.getMethod(currClass, currGetMethodName = this.getGetterMethodName(propertyNames[idx]))) == null) break;
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{currgetterMethod}));
                            retValue = synMethod.addCall(currgetterMethod, filePositionInfo, new Param[]{retValue});
                            getterMethod = currgetterMethod;
                        }
                    }
                    this.generateCallToSink(retValue, getterMethod, synMethod, filePositionInfo, global);
                }
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private IMethod getMethod(IClass beanClass, String methodName) {
        for (IMethod method : beanClass.getAllMethods()) {
            if (!methodName.equals(method.getName().toString())) continue;
            return method;
        }
        return null;
    }

    private String getGetterMethodName(String propertyName) {
        String getterMethodName = null;
        getterMethodName = propertyName.length() == 1 ? "get" + propertyName.toUpperCase() : "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return getterMethodName;
    }

    private void generateCallToSink(Local inputParam, IMethod getterMethod, HighLevelSyntheticMethod synMethod, FilePositionInfo filePositionInfo, Param global) {
        String callToGetWriterSig = "javax.servlet.ServletResponse.getWriter():java.io.PrintWriter";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callToGetWriterSig}));
        Local writerObject = synMethod.addCall(callToGetWriterSig, filePositionInfo, new Param[]{EnclosingFormal.SECOND});
        StringBuilder callSig = new StringBuilder("java.io.Writer.write(");
        callSig.append(inputParam.getDeclaredVDBType());
        callSig.append(")");
        callSig.append(":void");
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig.toString()}));
        synMethod.addCall(callSig.toString(), filePositionInfo, new Param[]{writerObject, inputParam});
    }

    private void generateCallsFromInputs(HighLevelSyntheticMethod synMethod) {
        try {
            List<Pair<JSFViewInputDataInfo, JsfNodeInfo>> beanRefInputList = this.m_jsfViewFileInfo.getBeanRefInputList();
            if (beanRefInputList.size() > 0) {
                for (Pair<JSFViewInputDataInfo, JsfNodeInfo> pair : beanRefInputList) {
                    String inputStr = ((JSFViewInputDataInfo)pair.fst).getValue();
                    String beanName = this.getBeanNameFromBeanRefStr(inputStr);
                    String[] propertyNames = this.getMethodOrFieldNamesFromBeanRefStr(inputStr);
                    if (beanName == null || propertyNames.length == 0) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{inputStr}));
                        continue;
                    }
                    String propertyName = propertyNames[0];
                    ManagedBean bean = this.m_jsfInfoManager.findBean(beanName);
                    if (bean == null) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{inputStr}));
                        continue;
                    }
                    IClass beanClass = bean.getClassType(this.app);
                    if (beanClass == null) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.value.not.bean", (Object[])new Object[]{inputStr}));
                        continue;
                    }
                    Param global = this.getVariable(bean, synMethod);
                    String setterMethodName = null;
                    setterMethodName = propertyName.length() == 1 ? "set" + propertyName.toUpperCase() : "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                    IMethod setterMethod = this.getMethod(beanClass, setterMethodName);
                    if (setterMethod == null) continue;
                    JSFViewInputDataInfo inputDataInfo = (JSFViewInputDataInfo)pair.fst;
                    JsfNodeInfo nodeInfo = (JsfNodeInfo)pair.snd;
                    if (inputDataInfo.hasValidator()) {
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{propertyName, "1"}));
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{setterMethod.getSignature()}));
                        synMethod.addCall(setterMethod, FilePositionInfo.make((String)this.m_viewFile, (int)nodeInfo.getLineNumber(), (int)nodeInfo.getColumnNumber()), new Param[]{global, Taint.taintWithParamName((String)propertyName)});
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{propertyName, "3"}));
                        inputDataInfo.getValidator().createWAFL(this.app, this.actions, synMethod, this.m_jsfInfoManager, global, (Param)Taint.taintWithParamName((String)propertyName));
                        continue;
                    }
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{propertyName, "1"}));
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{setterMethod.getSignature()}));
                    synMethod.addCall(setterMethod, FilePositionInfo.make((String)this.m_viewFile, (int)nodeInfo.getLineNumber(), (int)nodeInfo.getColumnNumber()), new Param[]{global, Taint.taintWithParamName((String)propertyName)});
                }
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private boolean isBeanReference(String str) {
        if (str == null) {
            return false;
        }
        return str.contains(".");
    }

    private Param getVariable(ManagedBean bean, HighLevelSyntheticMethod synMethod) {
        JSFBeanScope beanScope = bean.getScope();
        if (beanScope.isGlobal()) {
            Collection globals = this.actions.getGlobals();
            for (Global currGlobal : globals) {
                if (!bean.match(currGlobal)) continue;
                return currGlobal;
            }
            return bean.createWAFLVariable(this.app, this.actions, synMethod);
        }
        return bean.createWAFLVariable(this.app, this.actions, synMethod);
    }

    private String getMappingViewFileName(String fromViewOutcomeValue) {
        try {
            NavigationCaseInfo ncInfo = this.m_jsfInfoManager.findForward(this.m_viewFile, fromViewOutcomeValue);
            if (ncInfo != null) {
                return ncInfo.getToViewId();
            }
            List<String> viewFileNameList = this.m_jsfInfoManager.getJsfConfigManager().getViewFiles();
            String currViewDirectory = this.m_viewFile.substring(0, this.m_viewFile.lastIndexOf(File.separator));
            String fileNameWithoutfileExtension = Jsf2GeneralUtil.combineFilePath(currViewDirectory, fromViewOutcomeValue);
            for (String currFileName : viewFileNameList) {
                String fileExtension;
                if (!currFileName.startsWith(fileNameWithoutfileExtension) || !(fileExtension = currFileName.substring(fileNameWithoutfileExtension.length())).startsWith(".") || fileExtension.contains(File.separator) || fileExtension.substring(1).contains(".")) continue;
                return currFileName;
            }
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.view.not.found", (Object[])new Object[]{fromViewOutcomeValue}));
            return null;
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            return null;
        }
    }

    private String[] getMethodOrFieldNamesFromBeanRefStr(String beanRefStr) {
        int index = beanRefStr.indexOf(".");
        if (index == -1 || index == 0) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.property.not.extracted", (Object[])new Object[]{beanRefStr}));
            return new String[0];
        }
        String refStrWithoutBeanName = null;
        refStrWithoutBeanName = beanRefStr.endsWith("}") && beanRefStr.startsWith("#{") ? beanRefStr.substring(index + 1, beanRefStr.length() - 1) : beanRefStr.substring(index + 1);
        String[] methodOrFieldNameList = refStrWithoutBeanName.split("\\.");
        return methodOrFieldNameList;
    }

    private String getBeanNameFromBeanRefStr(String beanRefStr) {
        int index = beanRefStr.indexOf(".");
        if (index == -1 || index == 0) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.bean.not.extracted", (Object[])new Object[]{beanRefStr}));
            return null;
        }
        String beanName = null;
        beanName = beanRefStr.startsWith("#{") ? beanRefStr.substring(2, index) : beanRefStr.substring(0, index);
        return beanName;
    }
}

