/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.Jsf2GeneralUtil;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebXmlParser {
    private List<String> m_facesConfigFiles = new ArrayList<String>();
    private List<String> m_jsfViewFileExtensions = new ArrayList<String>();
    private String webContentDirectory;

    WebXmlParser(String webXmlFileName, String webContentDirectoryName) throws IOException, SAXException {
        this.webContentDirectory = webContentDirectoryName;
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(webXmlFileName);
        Document document = parser.getDocument();
        this.populate(document, webXmlFileName);
    }

    private void populate(Document document, String webXmlFileName) {
        try {
            Element root = document.getDocumentElement();
            this.recurseNodes(root);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{webXmlFileName}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void recurseNodes(Node currentNode) {
        this.handleNode(currentNode);
        NodeList nodes = currentNode.getChildNodes();
        if (nodes == null) {
            System.out.println("List of child nodes was null");
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.recurseNodes(nodes.item(i));
        }
    }

    private void handleNode(Node inNode) {
        Node child;
        int index;
        NodeList childNodes;
        if (inNode.getNodeName().equalsIgnoreCase("context-param")) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"context-param"}));
            childNodes = inNode.getChildNodes();
            boolean isConfigFiles = false;
            for (index = 0; index < childNodes.getLength(); ++index) {
                String[] configFileNames;
                String paramValueStr;
                child = childNodes.item(index);
                if (child.getNodeName().equalsIgnoreCase("param-name") && this.containChildNode(child, "javax.faces.CONFIG_FILES")) {
                    isConfigFiles = true;
                }
                if (!child.getNodeName().equalsIgnoreCase("param-value") || !isConfigFiles || (paramValueStr = child.getChildNodes().item(0).getNodeValue()) == null) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"param-name=javax.faces.CONFIG_FILES"}));
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"param-value=" + paramValueStr}));
                for (String configFileName : configFileNames = paramValueStr.split(",")) {
                    String canonicalPath = Jsf2GeneralUtil.combineFilePath(this.webContentDirectory, configFileName);
                    this.m_facesConfigFiles.add(canonicalPath);
                }
                return;
            }
        }
        if (inNode.getNodeName().equalsIgnoreCase("context-param")) {
            childNodes = inNode.getChildNodes();
            boolean specifyFileExtension = false;
            for (index = 0; index < childNodes.getLength(); ++index) {
                child = childNodes.item(index);
                if (child.getNodeName().equalsIgnoreCase("param-name") && (this.containChildNode(child, "javax.faces.FACELETS_VIEW_MAPPINGS") || this.containChildNode(child, "javax.faces.DEFAULT_SUFFIX"))) {
                    specifyFileExtension = true;
                }
                if (!child.getNodeName().equalsIgnoreCase("param-value") || !specifyFileExtension) continue;
                String fileExtensions = child.getChildNodes().item(0).getNodeValue();
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"param-name=javax.faces.FACELETS_VIEW_MAPPINGS / javax.faces.DEFAULT_SUFFIX"}));
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"param-value=" + fileExtensions}));
                if (fileExtensions == null) continue;
                this.addJsfViewFileExtensions(fileExtensions);
                return;
            }
        }
    }

    private void addJsfViewFileExtensions(String fileExtensions) {
        String[] fExtensions = fileExtensions.split(" |;");
        if (fExtensions.length == 0) {
            return;
        }
        for (String fExtension : fExtensions) {
            while (fExtension.contains(" ")) {
                fExtension = fExtension.replace(" ", "");
            }
            if (fExtension.startsWith("*")) {
                fExtension = fExtension.substring(1);
            }
            if (this.m_jsfViewFileExtensions.contains(fExtension) || !fExtension.startsWith(".")) continue;
            this.m_jsfViewFileExtensions.add(fExtension);
        }
    }

    private boolean containChildNode(Node node, String nodeValue) {
        if (node == null || nodeValue == null) {
            return false;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeValue().equalsIgnoreCase(nodeValue)) continue;
            return true;
        }
        return false;
    }

    public List<String> getConfigFileList() {
        return this.m_facesConfigFiles;
    }

    public List<String> getJsfViewFileExtensions() {
        if (this.m_jsfViewFileExtensions.size() == 0) {
            this.m_jsfViewFileExtensions.add(".xhtml");
            this.m_jsfViewFileExtensions.add(".jsp");
        }
        return this.m_jsfViewFileExtensions;
    }

    public static void main(String[] args) {
        try {
            String fileName = "C:\\TestApps\\F4F Apps\\JSFSampleApplication\\WebContent\\WEB-INF\\web_test_added.xml";
            String webContentDir = "C:\\TestApps\\F4F Apps\\JSFSampleApplication\\WebContent";
            WebXmlParser webXmlInfo = new WebXmlParser(fileName, webContentDir);
            System.out.println("Config file list: ");
            for (String str : webXmlInfo.getConfigFileList()) {
                System.out.println(str);
            }
            System.out.println("JSF View file extions: ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

