/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.commands;

import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.handlers.PrepareHandler;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.cli.config.SastServicesProgressTracker;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class PrepareCommand
extends Command {
    private PrepareHandler m_handler;

    public PrepareCommand() {
    }

    public PrepareCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.NAMESPACE_CONFIGURATION);
        this.setName("prepare");
        this.setDescription(Messages.PREPARE_COMMAND_DESCRIPTION);
        this.setOptions(this.buildOptions(), true);
        this.enableLogLevelOptions();
    }

    public Command createCommand(String[] args) {
        return new PrepareCommand(args);
    }

    public void execute() {
        int rc = -1;
        try {
            CommandLine cmd = this.getCommandLine();
            if (cmd == null) {
                return;
            }
            if (this.m_handler == null && SystemUtil.getSastExecutionEnv() != null && SystemUtil.getSastExecutionEnv().equals("AppScan360")) {
                this.m_handler = new PrepareHandler(new SastServicesProgressTracker());
            }
            if (this.m_handler == null) {
                this.m_handler = new PrepareHandler();
            }
            String saveFile = null;
            String saveLocation = null;
            String logLocation = null;
            String configFile = null;
            if (cmd.hasOption("n")) {
                saveFile = cmd.getOptionValue("n");
            }
            if (cmd.hasOption("d")) {
                saveLocation = Paths.get(cmd.getOptionValue("d"), new String[0]).toAbsolutePath().normalize().toString();
            }
            if (cmd.hasOption("l")) {
                logLocation = cmd.getOptionValue("l");
            }
            if (cmd.hasOption("c")) {
                configFile = cmd.getOptionValue("c");
            }
            if (cmd.hasOption("f")) {
                System.setProperty("IPVA_FORMAT", cmd.getOptionValue("f"));
            }
            if (cmd.hasOption("ne")) {
                System.setProperty("NO_ENCRYPT", "");
            }
            if (cmd.hasOption("sp")) {
                // empty if block
            }
            System.setProperty("show-progress", "");
            if (cmd.hasOption("t")) {
                System.setProperty("thirdParty", "");
            }
            if (cmd.hasOption("oso")) {
                System.setProperty("OPENSOURCE_ONLY", "");
            }
            if (cmd.hasOption("sco")) {
                System.setProperty("SOURCE_CODE_ONLY", "");
            }
            if (cmd.hasOption("sao")) {
                System.setProperty("STATIC_ANALYSIS_ONLY", "");
            }
            if (cmd.hasOption("dr")) {
                System.setProperty("dryRun", "");
            }
            if (cmd.hasOption("s")) {
                System.setProperty("scan_speed", cmd.getOptionValue("s"));
            }
            if (cmd.hasOption("jdk")) {
                System.setProperty("alternateJDK", cmd.getOptionValue("jdk"));
            }
            if (cmd.hasOption("ds") || cmd.hasOption("ns")) {
                System.setProperty("DISABLE_SECRETS", "");
            }
            if (cmd.hasOption("es")) {
                System.setProperty("ENABLE_SECRETS", "");
            }
            if (cmd.hasOption("so")) {
                System.setProperty("SECRETS_ONLY", "");
            }
            if (cmd.hasOption("nc")) {
                System.setProperty("NO_CONFIG_FILES", "");
            }
            rc = this.m_handler.configure(saveFile, saveLocation, logLocation, configFile);
        }
        catch (Exception e) {
            Message message = new Message((Throwable)e);
            m_logManager.log(message);
        }
        if (SystemUtil.isCommonEngine() && rc < 0) {
            System.exit(rc);
        }
    }

    public int getLogLevel(CommandLine cmd) {
        if (this.getEnableLogLevels() && this.getDebug() && cmd.hasOption("X")) {
            return 0;
        }
        return 1;
    }

    protected Options getVisibleOptions(Options options) {
        Options visibleOptions = new Options();
        for (Object obj : options.getOptions()) {
            Option opt = (Option)obj;
            if ("ne".equals(opt.getOpt()) || "f".equals(opt.getOpt()) || "ns".equals(opt.getOpt())) continue;
            visibleOptions.addOption(opt);
        }
        return visibleOptions;
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionGroup group = new OptionGroup();
        OptionBuilder.withArgName((String)Messages.ARTIFACTNAME_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.ARTIFACTNAME_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"n"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withArgName((String)Messages.SCAN_SPEED_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.SCAN_SPEED_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"s"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withArgName((String)Messages.SAVELOCATION_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.SAVELOCATION_OPTION_DESCRIPTION_IRX);
        group.addOption(OptionBuilder.create((String)"d"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withArgName((String)Messages.LOGLOCATION_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.LOGLOCATION_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"l"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withArgName((String)Messages.CONFIGFILE_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.CONFIGFILE_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"c"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        group.addOption(OptionBuilder.create((String)"ne"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.FORMAT_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"f"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"thirdParty");
        OptionBuilder.withDescription((String)Messages.THIRDPARTY_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"t"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"openSourceOnly");
        OptionBuilder.withDescription((String)Messages.OPENSOURCEONLY_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"oso"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"sourceCodeOnly");
        OptionBuilder.withDescription((String)Messages.SOURCECODEONLY_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"sco"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"staticAnalysisOnly");
        OptionBuilder.withDescription((String)Messages.STATICONLY_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"sao"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"dryRun");
        OptionBuilder.withDescription((String)Messages.DRY_RUN_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"dr"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"show-progress");
        OptionBuilder.withDescription((String)Messages.SHOW_PROGRESS_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"sp"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"noConfigFiles");
        OptionBuilder.withDescription((String)Messages.NO_CONFIG_FILES_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"nc"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withArgName((String)Messages.JDK_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.JDK_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"jdk"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"noSecrets");
        OptionBuilder.withDescription((String)"");
        group.addOption(OptionBuilder.create((String)"ns"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"disableSecrets");
        OptionBuilder.withDescription((String)Messages.DISABLE_SECRETS_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"ds"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"enableSecrets");
        OptionBuilder.withDescription((String)Messages.ENABLE_SECRETS_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"es"));
        options.addOptionGroup(group);
        group = new OptionGroup();
        OptionBuilder.withLongOpt((String)"secretsOnly");
        OptionBuilder.withDescription((String)Messages.SECRETSONLY_OPTION_DESCRIPTION);
        group.addOption(OptionBuilder.create((String)"so"));
        options.addOptionGroup(group);
        return options;
    }
}

