/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.common.utils.ConsoleUtil;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfoManager;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class BuildInfoHandler {
    private IConsole m_console = CommonCLICore.getIOConsole();
    private ScanManager m_manager = ScanManager.getInstance();
    private IScan m_scan = this.m_manager.getActiveScan();
    private IProgress m_progress = new ProgressAdapter(this.m_scan);

    private boolean isScanActive() {
        if (this.m_scan == null) {
            this.m_progress = new ProgressAdapter(null);
            this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_OPEN));
            return false;
        }
        return true;
    }

    private IScanTarget getScanTargetByPath(String targetPath) {
        IScanTarget toReturn = null;
        if (this.isScanActive()) {
            for (IScanTarget target : this.m_scan.getScanTargets()) {
                if (!target.getPath().equals(new File(targetPath).getPath())) continue;
                toReturn = target;
                break;
            }
            if (toReturn == null) {
                this.m_progress.setStatus(new Message(2, Messages.bind(Messages.SCAN_TARGET_NOT_FOUND, targetPath)));
            }
        }
        return toReturn;
    }

    public void listProperties(String target, boolean verbose) {
        if (this.isScanActive()) {
            IScanTarget scanTarget = null;
            scanTarget = target == null ? this.m_manager.getActiveScanTarget() : this.getScanTargetByPath(target);
            if (scanTarget != null && scanTarget.getBuildInfoManager() != null) {
                IBuildInfoManager buildInfoManager = scanTarget.getBuildInfoManager();
                Iterator iter = buildInfoManager.iterator();
                ArrayList<String[]> buildInfoData = new ArrayList<String[]>();
                Object[] headers = null;
                if (!verbose) {
                    headers = new String[]{"Property", "Value"};
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        buildInfoData.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
                    }
                } else {
                    headers = new String[]{"Property", "Value", "User Defined", "User Edited", "Original Discovered Value"};
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        String key = (String)entry.getKey();
                        String[] row = new String[]{key, (String)entry.getValue(), String.valueOf(buildInfoManager.isUserDefined(key)), String.valueOf(buildInfoManager.isUserEdited(key)), buildInfoManager.getDiscoveredProperty(key)};
                        buildInfoData.add(row);
                    }
                }
                this.m_console.println(ConsoleUtil.generateTable((String)("Target: " + scanTarget.getName()), (Object[])headers, buildInfoData));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_TARGET_OPEN));
            }
        }
    }

    public void updateProperty(String target, String key, String value) {
        if (this.isScanActive()) {
            this.m_scan.setTransformed(false);
            IScanTarget scanTarget = null;
            scanTarget = target == null ? this.m_manager.getActiveScanTarget() : this.getScanTargetByPath(target);
            if (scanTarget != null && scanTarget.getBuildInfoManager() != null) {
                scanTarget.getBuildInfoManager().setProperty(key, value);
                scanTarget.getBuildInfoManager().commit(true);
            } else {
                this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_TARGET_OPEN));
            }
        }
    }

    public void addProperty(String target, String key, String value) {
        if (this.isScanActive()) {
            this.m_scan.setTransformed(false);
            IScanTarget scanTarget = null;
            scanTarget = target == null ? this.m_manager.getActiveScanTarget() : this.getScanTargetByPath(target);
            if (scanTarget != null && scanTarget.getBuildInfoManager() != null) {
                scanTarget.getBuildInfoManager().setProperty(key, value);
                scanTarget.getBuildInfoManager().commit(true);
            } else {
                this.m_progress.setStatus(new Message(2, Messages.bind(Messages.SCAN_TARGET_NOT_FOUND, target)));
            }
        }
    }

    public void removeProperty(String target, String key) {
        if (this.isScanActive()) {
            this.m_scan.setTransformed(false);
            IScanTarget scanTarget = null;
            scanTarget = target == null ? this.m_manager.getActiveScanTarget() : this.getScanTargetByPath(target);
            if (scanTarget != null && scanTarget.getBuildInfoManager() != null) {
                IBuildInfoManager buildInfoManager = scanTarget.getBuildInfoManager();
                boolean isRemoved = false;
                Iterator iter = buildInfoManager.iterator();
                while (!isRemoved && iter.hasNext()) {
                    Map.Entry current = (Map.Entry)iter.next();
                    if (!((String)current.getKey()).equals(key)) continue;
                    buildInfoManager.restoreDiscoveredProperty(key);
                    isRemoved = true;
                }
                if (isRemoved) {
                    buildInfoManager.commit(true);
                }
            } else {
                this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_TARGET_OPEN));
            }
        }
    }

    public void restoreProperty(String target, String key) {
        if (this.isScanActive()) {
            this.m_scan.setTransformed(false);
            IScanTarget scanTarget = null;
            scanTarget = target == null ? this.m_manager.getActiveScanTarget() : this.getScanTargetByPath(target);
            if (scanTarget != null && scanTarget.getBuildInfoManager() != null) {
                scanTarget.getBuildInfoManager().restoreDiscoveredProperty(key);
                scanTarget.getBuildInfoManager().commit(true);
            } else {
                this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_TARGET_OPEN));
            }
        }
    }

    public void restoreProperties(String target) {
        if (this.isScanActive()) {
            this.m_scan.setTransformed(false);
            IScanTarget scanTarget = null;
            scanTarget = target == null ? this.m_manager.getActiveScanTarget() : this.getScanTargetByPath(target);
            if (scanTarget != null && scanTarget.getBuildInfoManager() != null) {
                scanTarget.getBuildInfoManager().restoreDefaults();
                scanTarget.getBuildInfoManager().commit(true);
            } else {
                this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_TARGET_OPEN));
            }
        }
    }
}

