/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.CryptoUtils;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.KeyUtil;
import java.io.File;
import java.security.Key;

public class PublicKeyHandler {
    public void getPublicKey(String saveLocation) {
        File pubKeyFile = new File(CommonCore.getDirectoryLocator().getConfig() + "rsa.pub");
        try {
            boolean keyIsUpdated = KeyUtil.updatePublicKey();
            if (keyIsUpdated) {
                Key pubKey = CryptoUtils.readPublicKey((String)(CommonCore.getDirectoryLocator().getConfig() + "rsa.pub"));
                if (pubKey != null && saveLocation != null) {
                    File extFile = new File(new File(saveLocation).getAbsolutePath() + File.separator + "rsa.pub");
                    IOUtil.copy((File)pubKeyFile, (File)extFile);
                    Message saved = new Message(2, Messages.bind(Messages.PUBLICKEY_SAVE_OK, extFile.getAbsolutePath()));
                    CommonCLICore.getIOConsole().println(saved);
                }
                Message updated = new Message(2, Messages.bind(Messages.PUBLICKEY_UPDATE_OK, CommonCore.getDirectoryLocator().getConfig() + "rsa.pub"));
                CommonCLICore.getIOConsole().println(updated);
            } else {
                Message error = new Message(4, Messages.PUBLICKEY_UPDATE_NOT_OK);
                CommonCLICore.getIOConsole().println(error);
            }
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message((Throwable)e));
            Message error = new Message(4, Messages.PUBLICKEY_SAVE_NOT_OK);
            CommonCLICore.getIOConsole().println(error);
        }
    }
}

