/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.utils.VisitingWriter;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.config.Configurator;
import com.ibm.appscan.internal.config.ScanModelVisitorWithProgress;
import com.ibm.appscan.internal.config.model.TargetInfoWriter;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class SkippedFileHandler {
    private static String SKIPPED_FILES_DIR = "fallback";
    private Configurator m_configurator = null;
    private File m_skippedFilesDir = null;

    public SkippedFileHandler(Configurator configurator) {
        this.m_configurator = configurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSkippedFiles() {
        boolean success = false;
        this.copyToSkippedFilesDirectory(this.m_configurator.getSkippedFiles());
        System.setProperty("SOURCE_CODE_ONLY", "");
        this.m_configurator.discover(this.m_skippedFilesDir, false, null);
        TargetInfoWriter writer = new TargetInfoWriter();
        IScan scan = ScanManager.getInstance().getActiveScan();
        ScanModelVisitorWithProgress visitor = new ScanModelVisitorWithProgress(null, false, scan);
        scan.accept((ScanModelVisitor)visitor);
        try {
            new VisitingWriter((IScanModelVisitable)scan, scan.getSaveLocation().getWorkLocation(), (ModelWriter)writer).write((IProgress)new ProgressAdapter(scan));
            if (this.m_configurator.getSkippedFiles().size() == DirectoryUtil.listFiles((File)this.m_skippedFilesDir).size()) {
                success = true;
            }
        }
        catch (IOException e) {
            CommonCLICore.getLogManager().log(new Message(Messages.FAILED_GENERATING_TARGETINFO_FILE, (Throwable)e));
        }
        finally {
            try {
                DirectoryUtil.delete((File)this.m_skippedFilesDir);
            }
            catch (IOException e) {
                CommonCLICore.getLogManager().log(new Message(Messages.FAILED_DELETING_SKIPPED_FILES_DIR, (Throwable)e));
            }
        }
        return success;
    }

    private void copyToSkippedFilesDirectory(Set<String> skippedFiles) {
        try {
            SaveLocation location = ScanManager.getInstance().getActiveScan().getSaveLocation();
            this.m_skippedFilesDir = new File(location.getWorkLocation(), SKIPPED_FILES_DIR);
            for (String path : skippedFiles) {
                File skippedFile = new File(path);
                File destFileDir = new File(this.m_skippedFilesDir, this.getTwoLevelParentDirectory(skippedFile));
                if (!destFileDir.exists()) {
                    destFileDir.mkdirs();
                }
                File destFile = new File(destFileDir, skippedFile.getName());
                IOUtil.copy((File)skippedFile, (File)destFile);
            }
        }
        catch (IOException e) {
            CommonCLICore.getLogManager().log(new Message(Messages.FAILED_COPYING_SKIPPED_FILES, (Throwable)e));
        }
    }

    private String getTwoLevelParentDirectory(File file) {
        String parentName = "";
        if (file.getParentFile() == null) {
            return parentName;
        }
        parentName = file.getParentFile().getName();
        String grandParentName = "";
        if (file.getParentFile().getParentFile() == null) {
            return parentName;
        }
        grandParentName = file.getParentFile().getParentFile().getName();
        return grandParentName + "/" + parentName;
    }
}

