/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.cli.config.handlers.SkippedFileHandler;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.config.Configurator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransformHandler {
    private File m_logDir = null;
    private File m_configDir = null;
    private Map<IScanTarget, List<String>> m_missingDependencies = new HashMap<IScanTarget, List<String>>();

    public void setLogDir(File logDir) {
        this.m_logDir = logDir;
    }

    public void setConfigDir(File configDir) {
        this.m_configDir = configDir;
    }

    public Map<IScanTarget, List<String>> getMissingDependencies() {
        return this.m_missingDependencies;
    }

    public int transform() {
        return this.transform((IProgress)new ProgressAdapter(ScanManager.getInstance().getActiveScan()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int transform(IProgress progress) {
        int rc = -1;
        IScan scan = ScanManager.getInstance().getActiveScan();
        if (scan == null) {
            progress.setStatus(new Message(2, Messages.NO_SCAN_OPEN));
            return rc;
        }
        if (ScanManager.isTreeTransformed((IScanModelVisitable)scan)) {
            progress.setStatus(new Message(2, Messages.ERR_TRANSFORMED));
            return rc;
        }
        Configurator configurator = new Configurator(scan);
        configurator.setLogDir(this.m_logDir);
        configurator.setConfigDir(this.m_configDir);
        try {
            SkippedFileHandler skippedFileHandler;
            progress.setStatus(new Message(1, Messages.JOB_GENERATE));
            rc = configurator.transform(progress) ? 0 : 1;
            this.m_missingDependencies = configurator.getMissingDependencies();
            if (this.m_missingDependencies.keySet().size() > 0) {
                for (IScanTarget target : this.m_missingDependencies.keySet()) {
                    progress.setStatus(new Message(1, Messages.bind(Messages.GENERATE_MISSING_PKG, target.getPath())));
                    for (String dep : this.m_missingDependencies.get(target)) {
                        progress.setStatus(new Message(1, "\t" + dep));
                    }
                }
            }
            if (!configurator.getSkippedFiles().isEmpty() && (skippedFileHandler = new SkippedFileHandler(configurator)).processSkippedFiles()) {
                rc = 1;
            }
            switch (rc) {
                case 0: 
                case 1: {
                    CommonCLICore.getIOConsole().println(new Message(1, Messages.GENERATE_OK));
                    return rc;
                }
                case 4: {
                    CommonCLICore.getIOConsole().println(new Message(2, Messages.GENERATE_INCOMPLETE));
                    return rc;
                }
                default: {
                    progress.setStatus(new Message(2, Messages.GENERATE_NOT_OK));
                    return rc;
                }
            }
        }
        catch (Exception e) {
            progress.setStatus(new Message((Throwable)e));
            rc = -1;
            return rc;
        }
        finally {
            int messageCount = scan.getLogManager().getMessages().size();
            if (messageCount == -1) return rc;
            List messages = scan.getLogManager().getMessages();
            for (int i = messageCount; i < messages.size(); ++i) {
                Message message = (Message)messages.get(i);
                if (message.getSeverity() < 2) continue;
                progress.setStatus(message);
            }
        }
        return rc;
    }
}

