/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.cli.config;

import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.common.model.IBuildInfoManager;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.config.Configurator;
import com.ibm.appscan.internal.common.model.ScanTarget;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public class ConfigurationWriter
extends ModelWriter
implements IModelXMLConstants {
    private DOMWriter m_config;
    private String m_configOutputDirectory = null;
    private String m_configFileName = "appscan-config.xml";

    protected void initWriters(File directory) throws IOException {
        this.m_configOutputDirectory = directory.getCanonicalPath();
        this.m_config = new DOMWriter(directory, this.m_configFileName, this.m_builder);
    }

    public void visit(final IScan scan) {
        this.m_config.beginElement("Configuration");
        this.m_config.beginElement("Targets");
        for (IScanTarget target : scan.getScanTargets()) {
            if (!(target instanceof ScanTarget)) continue;
            this.m_config.beginElement("Target");
            this.m_config.setAttribute("path", target.getPath());
            this.m_config.endElement();
        }
        this.m_config.endElement();
        this.m_config.beginElement("TargetSettings");
        Configurator configurator = new Configurator(scan);
        final Map deps = configurator.getMissingDependencies();
        for (IScanTarget target : scan.getScanTargets()) {
            ScanModelVisitor visitor = new ScanModelVisitor(){

                public void visit(IScanTarget target) {
                    if (!target.isDirectoryTarget() && target instanceof ScanTarget && !target.getPath().startsWith(scan.getSaveLocation().getWorkLocation().getAbsolutePath()) || deps.get(target) != null) {
                        IBuildInfoManager buildInfoManager;
                        ConfigurationWriter.this.m_config.beginElement("Target");
                        ConfigurationWriter.this.m_config.setAttribute("path", target.getPath());
                        List depPackages = (List)deps.get(target);
                        if (depPackages != null && depPackages.size() > 0) {
                            String depComment = Messages.CONFIGURATION_FILE_ADD_MISSING_DEPENDENCIES;
                            for (int i = 0; i < depPackages.size(); ++i) {
                                String depPackage = (String)depPackages.get(i);
                                depComment = depComment + "\n\t\t\t\t" + depPackage;
                                if (i == depPackages.size() - 1) continue;
                                depComment = depComment + ",";
                            }
                            Comment comment = ConfigurationWriter.this.m_config.getDocument().createComment(depComment);
                            ConfigurationWriter.this.m_config.appendNode((Node)comment);
                            ConfigurationWriter.this.m_config.beginElement("CustomBuildInfo");
                            if (target.getBuildInfoManager() != null) {
                                String classpath = target.getBuildInfoManager().getProperty("additional_classpath");
                                ConfigurationWriter.this.m_config.setAttribute("additional_classpath", classpath == null ? "" : classpath);
                            }
                            ConfigurationWriter.this.m_config.endElement();
                        }
                        if ((buildInfoManager = target.getBuildInfoManager()) != null) {
                            for (Map.Entry buildInfo : buildInfoManager) {
                                String key = (String)buildInfo.getKey();
                                if (!buildInfoManager.isUserDefined(key) && !buildInfoManager.isUserEdited(key)) continue;
                                ConfigurationWriter.this.m_config.beginElement("CustomBuildInfo");
                                ConfigurationWriter.this.m_config.setAttribute((String)buildInfo.getKey(), (String)buildInfo.getValue());
                                ConfigurationWriter.this.m_config.endElement();
                            }
                        }
                        ConfigurationWriter.this.m_config.endElement();
                    }
                }
            };
            target.accept(visitor);
        }
        this.m_config.endElement();
        this.m_config.endElement();
    }

    public void write() throws TransformerException {
        this.m_transformer.setOutputProperty("omit-xml-declaration", "no");
        this.m_config.write(this.m_transformer);
    }

    public String getOutputLocation() {
        return this.m_configOutputDirectory + File.separator + this.m_configFileName;
    }
}

