/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.auth;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.auth.LoginType;
import com.hcl.appscan.sdk.error.HttpException;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class AuthenticationHandler
implements CoreConstants {
    private IAuthenticationProvider m_authProvider;

    public AuthenticationHandler(IAuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    public boolean login(String username, String password, boolean persist) throws IOException, JSONException {
        return this.login(username, password, persist, LoginType.ASoC);
    }

    public boolean login(String username, String password, boolean persist, LoginType type) throws IOException, JSONException {
        return this.login(username, password, persist, type, null);
    }

    public boolean login(String username, String password, boolean persist, LoginType type, String clientType) throws IOException, JSONException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("charset", "utf-8");
        HashMap<String, String> params = new HashMap<String, String>();
        if (type == LoginType.ASoC_Federated) {
            params.put("KeyId", username);
            params.put("KeySecret", password);
            if (clientType != null) {
                clientType = clientType.replaceAll("[^a-zA-Z0-9\\-\\._]", "");
                params.put("ClientType", clientType);
                headers.put("ClientType", clientType);
            }
        } else {
            throw new HttpException(500, Messages.getMessage("error.login.type.deprectated", new Object[0]));
        }
        String url = this.m_authProvider.getServer() + "/api/v2/Account/ApiKeyLogin";
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        HttpResponse response = client.postForm(url, headers, params);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            if (persist) {
                JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
                String token = object.getString("Token");
                this.m_authProvider.saveConnection(token);
            }
            return true;
        }
        String reason = response.getResponseBodyAsString() == null ? Messages.getMessage("message.unknown", new Object[0]) : response.getResponseBodyAsString();
        throw new HttpException(response.getResponseCode(), reason);
    }

    public boolean isTokenExpired() {
        boolean isExpired;
        String request_url = this.m_authProvider.getServer() + "/api/V2/Apps/Count";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(false);
        headers.put("Accept", "application/json");
        headers.put("charset", "utf-8");
        HttpClient httpClient = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse httpResponse = httpClient.get(request_url, headers, null);
            isExpired = httpResponse.getResponseCode() != 200;
        }
        catch (IOException e) {
            isExpired = true;
        }
        return isExpired;
    }
}

