/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners;

import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.results.CloudResultsProvider;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.scan.IScan;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.ScanConstants;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.Serializable;
import java.util.Map;

public abstract class ASoCScan
implements IScan,
ScanConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private String m_target;
    private String m_scanId;
    private IProgress m_progress;
    private IScanServiceProvider m_serviceProvider;
    private Map<String, String> m_properties;

    public ASoCScan(Map<String, String> properties, IScanServiceProvider provider) {
        this(properties, new DefaultProgress(), provider);
    }

    public ASoCScan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        this.m_target = properties.remove("target");
        this.m_properties = properties;
        if (!this.m_properties.containsKey("ScanName")) {
            this.m_properties.put("ScanName", this.getType() + SystemUtil.getTimeStamp());
        }
        this.m_progress = progress;
        this.m_serviceProvider = provider;
    }

    @Override
    public String getScanId() {
        return this.m_scanId;
    }

    @Override
    public String getName() {
        return this.m_properties.get("ScanName");
    }

    @Override
    public IResultsProvider getResultsProvider() {
        CloudResultsProvider provider = new CloudResultsProvider(this.m_scanId, this.getType(), this.m_serviceProvider, this.m_progress);
        provider.setReportFormat(this.getReportFormat());
        return provider;
    }

    protected void setScanId(String id) {
        this.m_scanId = id;
    }

    protected String getAppId() {
        return this.m_properties.get("AppId");
    }

    protected String getTarget() {
        return this.m_target;
    }

    public IProgress getProgress() {
        return this.m_progress;
    }

    @Override
    public IScanServiceProvider getServiceProvider() {
        return this.m_serviceProvider;
    }

    protected Map<String, String> getProperties() {
        if (!this.m_properties.containsKey("Locale")) {
            this.m_properties.put("Locale", SystemUtil.getLocale());
        }
        if (!this.m_properties.containsKey("EnableMailNotification") || !Boolean.parseBoolean(this.m_properties.get("EnableMailNotification"))) {
            this.m_properties.put("EnableMailNotification", Boolean.toString(false));
        }
        return this.m_properties;
    }

    @Override
    public abstract String getReportFormat();
}

