/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.AppScanException;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.scan.IScanManager;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scan.ITarget;
import com.hcl.appscan.sdk.scanners.sast.SASTScan;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.hcl.appscan.sdk.scanners.sast.xml.ModelWriter;
import com.hcl.appscan.sdk.scanners.sast.xml.XmlWriter;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class SASTScanManager
implements IScanManager {
    private List<ISASTTarget> m_targets;
    private SASTScan m_scan;
    private String m_workingDirectory;
    private boolean m_isThirdPartyScanningEnabled = false;
    private boolean m_isOpenSourceOnlyEnabled = false;
    private boolean m_isSourceCodeOnlyEnabled = false;
    private boolean m_isStaticAnalysisOnlyEnabled = false;

    public SASTScanManager(String workingDir) {
        this.m_workingDirectory = workingDir;
        this.m_targets = new ArrayList<ISASTTarget>();
    }

    @Override
    public void prepare(IProgress progress, Map<String, String> properties) throws AppScanException {
        this.createConfig();
        properties.put("target", this.m_workingDirectory);
        properties.put("prepareOnly", Boolean.toString(true));
        if (!properties.containsKey("ScanName")) {
            properties.put("ScanName", this.getDefaultScanName());
        }
        this.run(progress, properties, null);
    }

    @Override
    public void analyze(IProgress progress, Map<String, String> properties, IScanServiceProvider provider) throws AppScanException {
        if (this.m_scan == null || this.m_scan.getIrx() == null) {
            this.createConfig();
            properties.put("target", this.m_workingDirectory);
        } else {
            properties.put("target", this.m_scan.getIrx().getAbsolutePath());
        }
        if (!properties.containsKey("ScanName")) {
            properties.put("ScanName", this.getDefaultScanName());
        }
        this.run(progress, properties, provider);
    }

    @Override
    public void addScanTarget(ITarget target) {
        if (target instanceof ISASTTarget) {
            this.m_targets.add((ISASTTarget)target);
        }
    }

    @Override
    public void getScanResults(File destination, String format) throws AppScanException {
        if (this.m_scan == null || this.m_scan.getResultsProvider() == null) {
            throw new AppScanException(Messages.getMessage("message.results.unavailable", new Object[0]));
        }
        this.m_scan.getResultsProvider().getResultsFile(destination, format);
    }

    public String getScanId() {
        return this.m_scan == null ? null : this.m_scan.getScanId();
    }

    private void run(IProgress progress, Map<String, String> properties, IScanServiceProvider provider) throws AppScanException {
        try {
            this.m_scan = new SASTScan(properties, progress, provider);
            this.m_scan.run();
        }
        catch (InvalidTargetException | ScannerException e) {
            throw new AppScanException(e.getLocalizedMessage());
        }
    }

    public void setIsThirdPartyScanningEnabled(boolean isThirdPartyScanningEnabled) {
        this.m_isThirdPartyScanningEnabled = isThirdPartyScanningEnabled;
    }

    public void setIsOpenSourceOnlyEnabled(boolean isOpenSourceOnlyEnabled) {
        this.m_isOpenSourceOnlyEnabled = isOpenSourceOnlyEnabled;
    }

    public void setIsSourceCodeOnlyEnabled(boolean isSourceCodeOnlyEnabled) {
        this.m_isSourceCodeOnlyEnabled = isSourceCodeOnlyEnabled;
    }

    public void setIsStaticAnalysisOnlyEnabled(boolean isStaticAnalysisOnlyEnabled) {
        this.m_isStaticAnalysisOnlyEnabled = isStaticAnalysisOnlyEnabled;
    }

    public void createConfig() throws AppScanException {
        this.createConfig(false);
    }

    public void createConfig(boolean useRelativeTargetPaths) throws AppScanException {
        if (this.m_targets.isEmpty()) {
            return;
        }
        try {
            XmlWriter writer = new XmlWriter(useRelativeTargetPaths);
            ((ModelWriter)writer).initWriters(new File(this.m_workingDirectory));
            ((ModelWriter)writer).visit(this.m_targets, this.m_isThirdPartyScanningEnabled, this.m_isOpenSourceOnlyEnabled, this.m_isSourceCodeOnlyEnabled, this.m_isStaticAnalysisOnlyEnabled);
            ((ModelWriter)writer).write();
        }
        catch (IOException | TransformerException e) {
            throw new AppScanException(e.getLocalizedMessage(), e);
        }
    }

    private String getDefaultScanName() {
        return new File(this.m_workingDirectory).getName() + SystemUtil.getTimeStamp();
    }
}

