/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast.xml;

import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public abstract class ModelWriter {
    protected DocumentBuilder m_builder;
    protected Transformer m_transformer;

    public final void initialize(File directory) throws ParserConfigurationException, TransformerConfigurationException, IOException {
        this.initDocumentBuilder();
        this.initTransformer();
    }

    protected void configureDocumentBuilderFactory(DocumentBuilderFactory factory) {
    }

    protected void configureTransformerFactory(TransformerFactory factory) {
    }

    protected void configureTransformer() {
        this.m_transformer.setOutputProperty("omit-xml-declaration", "yes");
        this.m_transformer.setOutputProperty("indent", "yes");
        this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    private void initTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        this.configureTransformerFactory(factory);
        this.m_transformer = factory.newTransformer();
        this.configureTransformer();
    }

    private void initDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.configureDocumentBuilderFactory(factory);
        this.m_builder = factory.newDocumentBuilder();
    }

    public abstract void initWriters(File var1) throws IOException;

    public abstract void write() throws TransformerException;

    public abstract String getOutputLocation();

    public abstract void visit(List<ISASTTarget> var1, boolean var2, boolean var3, boolean var4, boolean var5);
}

