/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.utils;

import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.logging.StdOutProgress;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ServerUtil {
    private static final String DEFAULT = "default";
    private static String CURRENT_SERVER = ServerUtil.getConfiguredServer();
    private static Map<String, String> m_servers = null;

    public static String getServerUrl() {
        return CURRENT_SERVER;
    }

    public static String getServerUrl(String region) {
        if (m_servers == null) {
            ServerUtil.initServerMap();
        }
        CURRENT_SERVER = region != null && m_servers.containsKey(region) ? m_servers.get(region) : m_servers.get(DEFAULT);
        return CURRENT_SERVER;
    }

    private static void initServerMap() {
        m_servers = new HashMap<String, String>();
        m_servers.put(DEFAULT, ServerUtil.getConfiguredServer());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String url = ServerUtil.getConfiguredServer() + "/api/v2/Utils/Regions";
        HttpClient client = new HttpClient();
        HttpResponse response = null;
        try {
            response = client.get(url, headers, null);
            if (response.isSuccess()) {
                JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
                if (obj == null) {
                    return;
                }
                JSONArray regions = obj.getJSONArray("Regions");
                for (int i = 0; i < regions.size(); ++i) {
                    JSONObject region = (JSONObject)regions.get(i);
                    m_servers.put(region.getString("Id"), region.getString("Url"));
                }
                String defaultRegion = obj.getString("DefaultRegion");
                m_servers.put(DEFAULT, m_servers.get(defaultRegion));
            }
        }
        catch (IOException | JSONException e) {
            new StdOutProgress().setStatus(e);
        }
    }

    private static String getConfiguredServer() {
        SystemUtil.setSystemProperties();
        String server = System.getProperty("BLUEMIX_SERVER");
        return server != null ? server : "https://cloud.appscan.com";
    }
}

