/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.utils;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ServiceUtil
implements CoreConstants {
    public static void getSAClientUtil(File destination) throws IOException {
        ServiceUtil.getSAClientUtil(destination, Proxy.NO_PROXY);
    }

    public static void getSAClientUtil(File destination, Proxy proxy) throws IOException {
        HttpClient client = new HttpClient(proxy);
        String request_url = SystemUtil.getDefaultServer() + String.format("/api/%s/StaticAnalyzer/SAClientUtil?os=%s", "SCX", SystemUtil.getOS());
        HttpResponse response = client.get(request_url, null, null);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            if (!destination.getParentFile().isDirectory()) {
                destination.getParentFile().mkdirs();
            }
        } else {
            throw new IOException(response.getResponseBodyAsString());
        }
        response.getResponseBodyAsFile(destination);
    }

    public static String getSAClientVersion() throws IOException {
        return ServiceUtil.getSAClientVersion(Proxy.NO_PROXY);
    }

    public static String getSAClientVersion(Proxy proxy) throws IOException {
        HttpClient client = new HttpClient(proxy);
        String request_url = SystemUtil.getDefaultServer() + String.format("/api/%s/StaticAnalyzer/SAClientUtil?os=%s&meta=%s", "SCX", SystemUtil.getOS(), "true");
        HttpResponse response = client.get(request_url, null, null);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            try {
                JSONArtifact responseContent = response.getResponseBodyAsJSON();
                if (responseContent != null) {
                    JSONObject object = (JSONObject)responseContent;
                    return object.getString("VersionNumber");
                }
            }
            catch (JSONException e) {
                return "0";
            }
        }
        return null;
    }

    public static boolean isValidUrl(String url, IAuthenticationProvider provider) {
        return ServiceUtil.isValidUrl(url, provider, Proxy.NO_PROXY);
    }

    public static boolean isValidUrl(String url, IAuthenticationProvider provider, Proxy proxy) {
        String request_url = provider.getServer() + "/api/v2/Scans/IsValidUrl";
        try {
            JSONArtifact responseContent;
            JSONObject body = new JSONObject();
            body.put("Url", (Object)url);
            HttpClient client = new HttpClient(proxy);
            HttpResponse response = client.post(request_url, provider.getAuthorizationHeader(false), body.toString());
            if (response.isSuccess() && (responseContent = response.getResponseBodyAsJSON()) != null) {
                JSONObject object = (JSONObject)responseContent;
                return object.getBoolean("IsValid");
            }
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return false;
    }
}

