/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.utils;

import com.hcl.appscan.sdk.utils.ServerUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SystemUtil {
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd_HH-mm-ss";

    public static String getTimeStamp() {
        return SystemUtil.getTimeStamp(TIMESTAMP_FORMAT);
    }

    public static String getTimeStamp(String format) {
        SimpleDateFormat sdf;
        Date date = new Date();
        try {
            sdf = new SimpleDateFormat(format);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
        }
        return sdf.format(date);
    }

    public static void setSystemProperties() {
        String[] properties;
        String opts = System.getenv("APPSCAN_OPTS");
        if (opts == null || opts.isEmpty()) {
            return;
        }
        for (String property : properties = opts.split(" ")) {
            String[] prop;
            if (property == null || property.trim().length() == 0) continue;
            if (property.startsWith("-D")) {
                property = property.substring(2);
            }
            if ((prop = property.split("=")).length == 2) {
                System.setProperty(prop[0], prop[1]);
                continue;
            }
            System.setProperty(property, "");
        }
    }

    public static String getOS() {
        String os = System.getProperty("os.name");
        os = os.startsWith("Windows") ? "win" : (os.startsWith("Mac") ? "mac" : "linux");
        return os;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static String getDefaultServer() {
        return ServerUtil.getServerUrl();
    }

    public static String getServer(String key) {
        if (key.contains("_")) {
            key = key.substring(0, key.indexOf("_"));
        }
        return ServerUtil.getServerUrl(key);
    }

    public static String getLocale() {
        return Locale.getDefault().toString().replace('_', '-');
    }

    public static boolean isSourceCodeOnly() {
        return System.getProperty("sourceCodeOnly") != null;
    }

    public static String getIrxMinorCacheHome() {
        return System.getProperty("irx_minor_cache_home".toUpperCase());
    }
}

