/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.JavaStageListener;
import com.hcl.irx.stage.StageListener;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;

public class StageEventManager {
    private static StageEventManager s_mgr = new StageEventManager();
    private ArrayList<StageListener> m_listeners = new ArrayList();
    private ArrayList<JavaStageListener> m_java_listeners = new ArrayList();

    private static StageEventManager getInstance() {
        if (s_mgr == null) {
            throw new RuntimeException("Singleton instance not available");
        }
        return s_mgr;
    }

    public static void removeAllListeners() {
        StageEventManager.getInstance().m_listeners = new ArrayList();
        StageEventManager.getInstance().m_java_listeners = new ArrayList();
    }

    public static void addStageListener(StageListener l) {
        StageEventManager.getInstance().m_listeners.add(l);
    }

    public static void addJavaStageListener(JavaStageListener l) {
        StageEventManager.getInstance().m_java_listeners.add(l);
    }

    public static void removeStageListener(StageListener l) {
        StageEventManager.getInstance().m_listeners.remove(l);
    }

    public static void removeJavaStageListener(JavaStageListener l) {
        StageEventManager.getInstance().m_java_listeners.remove(l);
    }

    public static void fireStageFileEvent(File path, InputStream in) throws IOException {
        for (StageListener l : StageEventManager.getInstance().m_listeners) {
            l.handleStageFile(path, in);
        }
    }

    public static void fireStageDependencyEvent(String string, InputStream in) throws IOException {
        for (StageListener l : StageEventManager.getInstance().m_listeners) {
            l.handleStageDependency(string, in);
        }
    }

    public static void fireAddDependencyFileReferenceEvent(File path) throws IOException {
        for (StageListener l : StageEventManager.getInstance().m_listeners) {
            l.handleAddDependencyFileReference(path);
        }
    }

    public static boolean fireStageClassInfoEvent(ClassInfo ci) throws IOException, ExclusionException {
        boolean ret = false;
        for (JavaStageListener l : StageEventManager.getInstance().m_java_listeners) {
            if (!l.handleStageClassFile(ci)) continue;
            ret = true;
        }
        return ret;
    }

    public static void fireStageLooseClassInfoEvent(ClassInfo ci) throws IOException, ExclusionException {
        for (JavaStageListener l : StageEventManager.getInstance().m_java_listeners) {
            l.handleStageLooseClassFile(ci);
        }
    }

    public static void fireStageSmapFileEvent(File path, InputStream in) throws IOException, ExclusionException {
        for (JavaStageListener l : StageEventManager.getInstance().m_java_listeners) {
            l.handleStageSmapFile(path, in);
        }
    }

    public static void fireStageInternalJavaCompressedFileEvent(String path, ZipEntry entry, InputStream in) throws IOException, ExclusionException {
        for (JavaStageListener l : StageEventManager.getInstance().m_java_listeners) {
            l.handleStageInternalJavaCompressedFile(path, entry, in);
        }
    }

    public static void fireStageJspFileEvent(String archive, String path, InputStream in) throws IOException {
        for (JavaStageListener l : StageEventManager.getInstance().m_java_listeners) {
            l.handleStageJspFile(archive, path, in);
        }
    }

    public static void fireStageExtraFileEvent(String archive, String entry_name, InputStream stream) throws IOException {
        for (JavaStageListener l : StageEventManager.getInstance().m_java_listeners) {
            l.handleStageExtraFile(archive, entry_name, stream);
        }
    }
}

