/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.cil;

import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.types.TypeReference;

public class CILLoadInstruction
implements ILoadInstruction {
    private final boolean isAddressOf;
    private final int index;
    private final TypeReference type;
    private final Translator.RuntimeType runtimeType;
    private final boolean isArgument;

    CILLoadInstruction(int index, TypeReference type, Translator.RuntimeType runtimeType, boolean isArgument, boolean isAddressOf) {
        this.index = index;
        this.type = type;
        this.runtimeType = runtimeType;
        this.isArgument = isArgument;
        this.isAddressOf = isAddressOf;
    }

    public String toString() {
        return "Load(" + (this.isAddressOf ? "?," : "") + (this.isArgument ? "arg" : "local") + "," + this.index + "," + this.type + "," + (Object)((Object)this.runtimeType) + ")";
    }

    public String getType() {
        return this.type.getName().toString();
    }

    public int getVarIndex() {
        return this.index;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public int[] getBranchTargets() {
        return Instruction.noInstructions;
    }

    public int getPoppedCount() {
        return 0;
    }

    public String getPushedType(String[] poppedTypesToCheck) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return this.runtimeType.size();
    }

    public boolean isFallThrough() {
        return true;
    }

    public boolean isPEI() {
        return false;
    }

    public IInstruction redirectTargets(int[] targetMap) {
        return this;
    }

    public void visit(IInstruction.Visitor v) {
        v.visitLocalLoad((ILoadInstruction)this);
    }

    public boolean isAddressOf() {
        return this.isAddressOf;
    }
}

