/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.configuration.ase;

import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.configuration.ase.IComponent;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASEFolderProvider
implements IComponent {
    private Map<String, String> m_folders;
    private IASEAuthenticationProvider m_authProvider;

    public ASEFolderProvider(IASEAuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    @Override
    public Map<String, String> getComponents() {
        if (this.m_folders == null) {
            this.loadFolders();
        }
        return this.m_folders;
    }

    @Override
    public String getComponentName(String id) {
        return this.getComponents().get(id);
    }

    private void loadFolders() {
        if (this.m_authProvider.isTokenExpired()) {
            return;
        }
        this.m_folders = new HashMap<String, String>();
        String url = this.m_authProvider.getServer() + "/api/folders";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(url, headers, null);
            if (!response.isSuccess()) {
                return;
            }
            JSONArray array = (JSONArray)response.getResponseBodyAsJSON();
            if (array == null) {
                return;
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                String id = object.getString("folderId");
                String path = object.getString("folderPath");
                if (id.equalsIgnoreCase("2")) continue;
                this.m_folders.put(id, path);
            }
        }
        catch (IOException | JSONException e) {
            this.m_folders = null;
        }
    }
}

