/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.presence;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.presence.IPresenceProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class CloudPresenceProvider
implements IPresenceProvider,
CoreConstants {
    private Map<String, String> m_presences;
    private IProgress m_progress;
    private IAuthenticationProvider m_authProvider;

    public CloudPresenceProvider(IAuthenticationProvider provider) {
        this(provider, new DefaultProgress());
    }

    public CloudPresenceProvider(IAuthenticationProvider provider, IProgress progress) {
        this.m_authProvider = provider;
        this.m_progress = progress;
    }

    @Override
    public Map<String, String> getPresences() {
        if (this.m_presences == null) {
            this.loadPresences();
        }
        return this.m_presences;
    }

    @Override
    public String getName(String id) {
        return this.getPresences().get(id);
    }

    @Override
    public boolean delete(String id) {
        if (!this.authenticated()) {
            return false;
        }
        String url = this.m_authProvider.getServer() + String.format("/api/v2/Presences/%s", id);
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.delete(url, headers, null);
            if (response.isSuccess()) {
                return true;
            }
            this.handleError(response);
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.deleting.presence", id)), e);
        }
        return false;
    }

    @Override
    public Map<String, String> getDetails(String id) {
        if (!this.authenticated()) {
            return null;
        }
        String url = this.m_authProvider.getServer() + String.format("/api/v2/Presences/%s", id);
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        HashMap<String, String> details = new HashMap<String, String>();
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.get(url, headers, null);
            if (response.isSuccess()) {
                JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
                for (Object key : json.keySet()) {
                    details.put((String)key, json.getString((String)key));
                }
            } else {
                this.handleError(response);
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.presence.details", id)), e);
        }
        return details;
    }

    @Override
    public String getNewKey(String id) {
        if (!this.authenticated()) {
            return null;
        }
        String key = null;
        String url = this.m_authProvider.getServer() + String.format("/api/v2/Presences/%s/NewKey", id);
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.get(url, headers, null);
            if (response.isSuccess()) {
                JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
                key = json.getString("Key");
            } else {
                this.handleError(response);
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.new.key", id)), e);
        }
        return key;
    }

    private void loadPresences() {
        if (!this.authenticated()) {
            return;
        }
        this.m_presences = new HashMap<String, String>();
        String url = this.m_authProvider.getServer() + "/api/v2/Presences" + "?fields=Name&sort=%2BName";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        headers.putAll(Collections.singletonMap("range", "items=0-999999"));
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.get(url, headers, null);
            if (response.isSuccess()) {
                JSONArray array = (JSONArray)response.getResponseBodyAsJSON();
                if (array == null) {
                    return;
                }
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    String id = object.getString("Id");
                    String name = object.getString("PresenceName");
                    this.m_presences.put(id, name);
                }
            } else {
                this.handleError(response);
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.loading.presences", new Object[0])), e);
            this.m_presences = null;
        }
    }

    private void handleError(HttpResponse response) throws IOException, JSONException {
        JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
        if (json != null && json.has("Message")) {
            this.m_progress.setStatus(new Message(2, json.getString("Message")));
        } else {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.service.general", response.getResponseCode())));
        }
    }

    private boolean authenticated() {
        if (this.m_authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.error", new Object[0])));
            return false;
        }
        return true;
    }
}

