/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.results;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.results.CloudResultsProvider;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class NonCompliantIssuesResultProvider
extends CloudResultsProvider {
    private static final long serialVersionUID = 1L;
    private static final String SCOPE = "Scan";

    public NonCompliantIssuesResultProvider(String scanId, String type, IScanServiceProvider provider, IProgress progress) {
        super(scanId, type, provider, progress);
    }

    @Override
    protected void loadResults() {
        try {
            JSONObject obj = this.m_scanProvider.getScanDetails(this.m_scanId);
            if (obj == null) {
                this.m_status = "Failed";
                return;
            }
            if (obj.has("Key") && obj.get("Key").equals("UNAUTHORIZED_ACTION")) {
                this.m_status = "Failed";
                return;
            }
            if (obj.has("Status") && obj.get("Status").equals("Unknown")) {
                this.m_status = "Unknown";
                return;
            }
            obj = (JSONObject)obj.get("LatestExecution");
            this.m_status = obj.getString("Status");
            if ("Failed".equalsIgnoreCase(this.m_status) && obj.has("UserMessage")) {
                this.m_progress.setStatus(new Message(2, obj.getString("UserMessage")));
                this.m_message = obj.getString("UserMessage");
            } else if ("Paused".equalsIgnoreCase(this.m_status)) {
                this.m_progress.setStatus(new Message(0, Messages.getMessage("message.suspend.job.byuser", "Scan Id: " + this.m_scanId)));
                this.m_message = Messages.getMessage("message.suspend.job.byuser", "Scan Id: " + this.m_scanId);
            } else if (!(this.m_status == null || this.m_status.equalsIgnoreCase("InQueue") || this.m_status.equalsIgnoreCase("Running") || this.m_status.equalsIgnoreCase("Pausing"))) {
                JSONArray array = this.m_scanProvider.getNonCompliantIssues(this.m_scanId);
                this.m_totalFindings = 0;
                block14: for (int i = 0; i < array.length(); ++i) {
                    JSONObject jobj = array.getJSONObject(i);
                    String sev = jobj.getString("Severity");
                    int count = jobj.getInt("Count");
                    switch (sev.toLowerCase()) {
                        case "high": {
                            this.m_highFindings = count;
                            this.m_totalFindings += count;
                            continue block14;
                        }
                        case "medium": {
                            this.m_mediumFindings = count;
                            this.m_totalFindings += count;
                            continue block14;
                        }
                        case "low": {
                            this.m_lowFindings = count;
                            this.m_totalFindings += count;
                            continue block14;
                        }
                        case "informational": {
                            this.m_infoFindings = count;
                            this.m_totalFindings += count;
                            continue block14;
                        }
                        default: {
                            this.m_totalFindings += count;
                        }
                    }
                }
                this.setHasResult(true);
                this.m_message = "";
            } else if ("Running".equalsIgnoreCase(this.m_status)) {
                this.m_message = "";
            }
        }
        catch (IOException | NullPointerException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details", e.getMessage())), e);
            this.m_status = "Failed";
        }
    }

    @Override
    protected void getReport(String scanId, String format, File destination) throws IOException, JSONException {
        String reportId = this.createNonCompliantIssuesReport(scanId, format);
        if (reportId == null) {
            return;
        }
        String status = this.getReportStatus(reportId);
        while (!status.equalsIgnoreCase("Ready") && !status.equalsIgnoreCase("Failed")) {
            try {
                Thread.sleep(3000L);
                status = this.getReportStatus(reportId);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!status.equalsIgnoreCase("Ready")) {
            throw new IOException("error.getting.issues");
        }
        HttpResponse response = this.downloadNonCompliantIssuesReport(reportId);
        if (destination.isDirectory()) {
            String fileName = "asoc_results_" + SystemUtil.getTimeStamp() + "." + format;
            destination = new File(destination, fileName);
        }
        destination.getParentFile().mkdirs();
        response.getResponseBodyAsFile(destination);
    }

    private HttpResponse downloadNonCompliantIssuesReport(String reportId) throws IOException, JSONException {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return null;
        }
        String request_url = authProvider.getServer() + String.format("/api/v2/Reports/Download/%s", reportId);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Length", "0");
        HttpClient client = new HttpClient(this.m_scanProvider.getAuthenticationProvider().getProxy());
        HttpResponse response = client.get(request_url, request_headers, null);
        int responseCode = response.getResponseCode();
        if (responseCode == 200) {
            return response;
        }
        if (responseCode == 500) {
            return this.downloadNonCompliantIssuesReport(reportId);
        }
        JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
        if (object.has("Message")) {
            if (response.getResponseCode() == 400) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", new Object[0])));
            } else {
                this.m_progress.setStatus(new Message(2, object.getString("Message")));
            }
        }
        return null;
    }

    private String createNonCompliantIssuesReport(String scanId, String format) throws IOException, JSONException {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return null;
        }
        String request_url = authProvider.getServer() + String.format("/api/v2/Reports/Security/%s/%s", SCOPE, scanId);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Type", "application/json; charset=UTF-8");
        request_headers.put("Accept", "application/json");
        HttpClient client = new HttpClient(this.m_scanProvider.getAuthenticationProvider().getProxy());
        HttpResponse response = client.post(request_url, request_headers, this.getBodyParams(format).toString());
        if (response.getResponseCode() != 200) {
            return null;
        }
        JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
        String reportId = obj.getString("Id");
        return reportId;
    }

    private JSONObject getBodyParams(String format) throws JSONException, UnsupportedEncodingException {
        JSONObject body = new JSONObject();
        body.put("Configuration", (Map)this.getConfiguration(format));
        body.put("ApplyPolicies", (Object)"All");
        return body;
    }

    private JSONObject getConfiguration(String format) throws JSONException {
        JSONObject configParams = new JSONObject();
        configParams.put("Summary", true);
        configParams.put("Details", true);
        configParams.put("Discussion", false);
        configParams.put("Overview", true);
        configParams.put("TableOfContent", true);
        configParams.put("Advisories", false);
        configParams.put("FixRecommendation", true);
        configParams.put("Articles", true);
        configParams.put("Coverage", true);
        configParams.put("History", true);
        configParams.put("IsTrialReport", false);
        configParams.put("ReportFileType", (Object)format);
        configParams.put("Title", (Object)this.getScanName());
        configParams.put("Notes", (Object)"");
        configParams.put("Locale", (Object)SystemUtil.getLocale());
        return configParams;
    }

    private String getScanName() {
        try {
            JSONObject obj = this.m_scanProvider.getScanDetails(this.m_scanId);
            return obj.getString("Name");
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details", e.getMessage())), e);
            return "";
        }
    }
}

