/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.dynamic;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.ASoCScan;
import com.hcl.appscan.sdk.scanners.dynamic.DASTConstants;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DASTScan
extends ASoCScan
implements DASTConstants {
    private static final long serialVersionUID = 1L;
    private static final String REPORT_FORMAT = "pdf";

    public DASTScan(Map<String, String> properties, IScanServiceProvider provider) {
        super(properties, new DefaultProgress(), provider);
    }

    public DASTScan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        super(properties, progress, provider);
    }

    @Override
    public void run() throws ScannerException, InvalidTargetException {
        String scanFile;
        String type = "DynamicAnalyzer";
        String target = this.getTarget();
        if (target == null) {
            throw new InvalidTargetException(Messages.getMessage("error.target.invalid", target));
        }
        Map<String, String> params = this.getProperties();
        params.put("StartingUrl", target);
        String scanLoginType = null;
        if (params.get("LoginType") != null) {
            scanLoginType = params.get("LoginType");
            params.remove("LoginType");
        }
        if ("Manual".equals(scanLoginType)) {
            String trafficFile = params.remove("trafficFile");
            if (trafficFile != null && new File(trafficFile).isFile()) {
                File fileTraffic = new File(trafficFile);
                try {
                    String fileTrafficId = this.getServiceProvider().submitFile(fileTraffic);
                    if (fileTrafficId == null) {
                        throw new ScannerException(Messages.getMessage("error.file.upload", fileTraffic.getName()));
                    }
                    params.put("LoginSequenceFileId", fileTrafficId);
                }
                catch (IOException e) {
                    throw new ScannerException(Messages.getMessage("error.scan.failed", e.getLocalizedMessage()));
                }
            } else if (trafficFile != null) {
                throw new ScannerException(Messages.getMessage("error.file.upload", trafficFile));
            }
        }
        if ((scanFile = params.remove("ScanFile")) != null && new File(scanFile).isFile()) {
            type = "DynamicAnalyzerWithFile";
            File file = new File(scanFile);
            try {
                String fileId = this.getServiceProvider().submitFile(file);
                if (fileId == null) {
                    throw new ScannerException(Messages.getMessage("error.file.upload", file.getName()));
                }
                params.put("ScanFileId", fileId);
            }
            catch (IOException e) {
                throw new ScannerException(Messages.getMessage("error.scan.failed", e.getLocalizedMessage()));
            }
        }
        this.setScanId(this.getServiceProvider().createAndExecuteScan(type, params));
        if (this.getScanId() == null) {
            throw new ScannerException(Messages.getMessage("error.creating.scan", new Object[0]));
        }
    }

    @Override
    public String getType() {
        return "Dynamic Analyzer";
    }

    @Override
    public String getReportFormat() {
        return REPORT_FORMAT;
    }
}

