/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.grammar.string.AbstractGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ISimplify;
import com.ibm.wala.automaton.grammar.string.ProductionRuleSet;
import com.ibm.wala.automaton.string.IVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class SimpleGrammar
extends AbstractGrammar
implements ISimplify {
    private ProductionRuleSet rules = new ProductionRuleSet();
    private IVariable startSymbol = null;

    public SimpleGrammar() {
    }

    public SimpleGrammar(IVariable startSymbol, Collection<? extends IProductionRule> rules) {
        this();
        this.addRules(rules);
        this.setStartSymbol(startSymbol);
    }

    public SimpleGrammar(IVariable startSymbol, IProductionRule[] rules) {
        this();
        ArrayList<IProductionRule> l = new ArrayList<IProductionRule>();
        for (int i = 0; i < rules.length; ++i) {
            l.add(rules[i]);
        }
        this.addRules(l);
        this.setStartSymbol(startSymbol);
    }

    public SimpleGrammar(IGrammar g) {
        this(g.getStartSymbol(), g.getRules());
    }

    @Override
    public IVariable getStartSymbol() {
        return this.startSymbol;
    }

    public void setStartSymbol(IVariable startSymbol) {
        this.startSymbol = startSymbol;
    }

    @Override
    public Set<IProductionRule> getRules() {
        return this.rules;
    }

    @Override
    public Set<IProductionRule> getRules(IVariable v) {
        return this.rules.getSet(v);
    }

    public Collection<IVariable> getLeftVariables() {
        return Collections.unmodifiableCollection(this.rules.keySet());
    }

    public void addRule(IProductionRule rule) {
        this.rules.add(rule);
    }

    public void addRules(Collection<? extends IProductionRule> rules) {
        this.addRules(rules.iterator());
    }

    public void addRules(Iterator<? extends IProductionRule> rules) {
        while (rules.hasNext()) {
            this.addRule(rules.next());
        }
    }

    public SimpleGrammar dup(IVariable start) {
        SimpleGrammar g = (SimpleGrammar)this.clone();
        g.rules = (ProductionRuleSet)g.rules.clone();
        g.startSymbol = start;
        return g;
    }

    @Override
    public SimpleGrammar dup() {
        return this.dup(this.startSymbol);
    }

    @Override
    public IGrammar copy(IGrammarCopier copier) {
        IGrammar g = copier.copy(this);
        if (g instanceof SimpleGrammar) {
            SimpleGrammar cfg = (SimpleGrammar)g;
            cfg.rules = (ProductionRuleSet)copier.copyRules(cfg.rules, new ProductionRuleSet());
            cfg.startSymbol = copier.copyStartSymbol(cfg.startSymbol);
        }
        return g;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SimpleGrammar cfg = (SimpleGrammar)obj;
        return (this.startSymbol == null ? cfg.getStartSymbol() == null : this.startSymbol.equals(cfg.getStartSymbol())) && this.rules.equals(cfg.getRules());
    }

    public String toString() {
        StringBuffer rulesStr = new StringBuffer();
        ArrayList<IProductionRule> rules = new ArrayList<IProductionRule>();
        for (IProductionRule rule : AUtil.sort(this.getRules())) {
            rules.add(rule);
        }
        Collections.sort(rules, new Comparator<IProductionRule>(){

            @Override
            public int compare(IProductionRule r1, IProductionRule r2) {
                return r1.getLeft().getName().compareTo(r2.getLeft().getName());
            }
        });
        int n = 0;
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            IProductionRule rule = (IProductionRule)i.next();
            rulesStr.append("  " + rule.toString());
            if (i.hasNext()) {
                rulesStr.append(AUtil.lineSeparator);
            }
            ++n;
        }
        return "start:" + this.getStartSymbol() + AUtil.lineSeparator + rulesStr;
    }

    @Override
    public SimpleGrammar toSimple() {
        return this;
    }
}

