/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.Transition;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class FilteredTransition
extends Transition {
    private static IFilter DEFAULT_FILTER = new IFilter(){

        @Override
        public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
            return outputs;
        }
    };
    private static ICondition DEFAULT_CONDITION = new ICondition(){

        @Override
        public boolean accept(ISymbol symbol, IMatchContext ctx) {
            return true;
        }

        @Override
        public Collection<ISymbol> getTerminals() {
            return new HashSet<ISymbol>();
        }
    };
    private IFilter filter;
    private ICondition condition;

    public FilteredTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, IFilter filter, ICondition condition) {
        super(preState, postState, inputSymbol, outputSymbols);
        this.filter = filter == null ? DEFAULT_FILTER : filter;
        this.condition = condition == null ? DEFAULT_CONDITION : condition;
    }

    public FilteredTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, IFilter filter) {
        super(preState, postState, inputSymbol, outputSymbols);
        this.filter = filter == null ? DEFAULT_FILTER : filter;
        this.condition = DEFAULT_CONDITION;
    }

    public FilteredTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, IFilter filter, ICondition condition) {
        super(preState, postState, inputSymbol, outputSymbols);
        this.filter = filter == null ? DEFAULT_FILTER : filter;
        this.condition = condition == null ? DEFAULT_CONDITION : condition;
    }

    public FilteredTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, ICondition condition) {
        super(preState, postState, inputSymbol, outputSymbols);
        this.filter = DEFAULT_FILTER;
        this.condition = condition == null ? DEFAULT_CONDITION : condition;
    }

    public FilteredTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, IFilter filter) {
        super(preState, postState, inputSymbol, outputSymbols);
        this.filter = filter == null ? DEFAULT_FILTER : filter;
        this.condition = DEFAULT_CONDITION;
    }

    public FilteredTransition(IState preState, IState postState, ISymbol inputSymbol, ICondition condition) {
        super(preState, postState, inputSymbol);
        this.filter = DEFAULT_FILTER;
        this.condition = condition == null ? DEFAULT_CONDITION : condition;
    }

    @Override
    public void appendOutputSymbols(List<? extends ISymbol> outputs) {
        super.appendOutputSymbols(outputs);
        final int len = outputs.size();
        final IFilter oldFilter = this.filter;
        this.filter = new IFilter(){

            @Override
            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                List<ISymbol> l = oldFilter.invoke(symbol, outputs.subList(0, outputs.size() - len));
                l.addAll(outputs.subList(len - 1, outputs.size()));
                return l;
            }
        };
    }

    @Override
    public void prependOutputSymbols(List<? extends ISymbol> outputs) {
        super.prependOutputSymbols(outputs);
        final int len = outputs.size();
        final IFilter oldFilter = this.filter;
        this.filter = new IFilter(){

            @Override
            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                List<ISymbol> l = oldFilter.invoke(symbol, outputs.subList(len, outputs.size()));
                l.addAll(0, outputs.subList(0, len));
                return l;
            }
        };
    }

    @Override
    public boolean accept(ISymbol s, IMatchContext ctx) {
        return !(s instanceof IVariable) && super.accept(s, ctx) && this.condition.accept(s, ctx);
    }

    @Override
    public List<ISymbol> transit(ISymbol s) {
        List<ISymbol> outputs = super.transit(s);
        if (outputs != null) {
            return this.filter.invoke(s, outputs);
        }
        return null;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public ICondition getCondition() {
        return this.condition;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.filter.hashCode() + this.condition.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            FilteredTransition t = (FilteredTransition)obj;
            return this.filter.equals(t.filter) && this.condition.equals(t.condition);
        }
        return false;
    }

    @Override
    public Collection<ISymbol> getTerminals() {
        Collection<ISymbol> s = super.getTerminals();
        s.addAll(this.condition.getTerminals());
        return s;
    }

    public static abstract class IObsoleteCondition
    implements ICondition {
        @Override
        public Collection<ISymbol> getTerminals() {
            return CharSymbol.ALL_ASCII_CHARS;
        }
    }

    public static interface ICondition {
        public boolean accept(ISymbol var1, IMatchContext var2);

        public Collection<ISymbol> getTerminals();
    }

    public static interface IFilter {
        public List<ISymbol> invoke(ISymbol var1, List<ISymbol> var2);
    }
}

