/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.BooleanSymbol;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RealSymbol;

public class IntSymbol
extends NumberSymbol
implements IEnumerableSymbol {
    public static final IntSymbol MAX = new IntSymbol(Long.MAX_VALUE);
    public static final IntSymbol MIN = new IntSymbol(Long.MIN_VALUE);
    public static final IntSymbol BOTTOM = new IntSymbol(Long.MIN_VALUE){

        @Override
        public IEnumerableSymbol getPred() {
            return BOTTOM;
        }

        @Override
        public IEnumerableSymbol getSucc() {
            return MIN;
        }
    };
    public static final IntSymbol TOP = new IntSymbol(Long.MAX_VALUE){

        @Override
        public IEnumerableSymbol getPred() {
            return MAX;
        }

        @Override
        public IEnumerableSymbol getSucc() {
            return TOP;
        }
    };

    public IntSymbol(int num) {
        super(num);
    }

    public IntSymbol(long num) {
        super(num);
    }

    public IntSymbol(Integer num) {
        super(num);
    }

    public IntSymbol(Long num) {
        super(num);
    }

    @Override
    public IEnumerableSymbol getMax() {
        return MAX;
    }

    @Override
    public IEnumerableSymbol getMin() {
        return MIN;
    }

    @Override
    public IEnumerableSymbol getTop() {
        return TOP;
    }

    @Override
    public IEnumerableSymbol getBottom() {
        return BOTTOM;
    }

    @Override
    public IEnumerableSymbol getPred() {
        long n = this.longValue();
        if (n == Long.MIN_VALUE) {
            return BOTTOM;
        }
        return new IntSymbol(n - 1L);
    }

    @Override
    public IEnumerableSymbol getSucc() {
        long n = this.longValue();
        if (n == Long.MAX_VALUE) {
            return TOP;
        }
        return new IntSymbol(n + 1L);
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof IntSymbol) {
            return new IComparableSymbol[]{o, this};
        }
        if (o instanceof RealSymbol) {
            return new IComparableSymbol[]{o, new RealSymbol(this.doubleValue())};
        }
        if (o instanceof BooleanSymbol) {
            BooleanSymbol b = (BooleanSymbol)o;
            return new IComparableSymbol[]{new IntSymbol(b.intValue()), new IntSymbol(this.intValue())};
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            return new IComparableSymbol[]{new RealSymbol(n.doubleValue()), new RealSymbol(this.doubleValue())};
        }
        return super.coerce(this);
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof IntSymbol) {
            IntSymbol is = (IntSymbol)o;
            Long d = this.longValue();
            return d.compareTo(is.longValue());
        }
        if (o instanceof CharSymbol) {
            CharSymbol cs = (CharSymbol)o;
            char c = cs.charValue();
            long d = (long)c - this.longValue();
            if (d == 0L) {
                return 0;
            }
            return d > 0L ? 1 : -1;
        }
        if (o instanceof Number) {
            NumberSymbol ns = (NumberSymbol)o;
            return ns.intValue() - this.intValue();
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }

    @Override
    public int rangeCompareTo(IEnumerableSymbol s) {
        try {
            if (s instanceof NumberSymbol) {
                return this.compareTo(s);
            }
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
        catch (IComparableSymbol.NotComparableException e) {
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
    }
}

