/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.BooleanSymbol;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.NumberSymbol;

public class RealSymbol
extends NumberSymbol {
    public static RealSymbol ANY = new AnyRealSymbol();

    protected RealSymbol(String num) {
        super(num);
    }

    public RealSymbol(double num) {
        super(num);
    }

    public RealSymbol(Double num) {
        super(num);
    }

    public RealSymbol(float num) {
        super(num);
    }

    public RealSymbol(Float num) {
        super(num);
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof IntSymbol) {
            IntSymbol i = (IntSymbol)o;
            return new IComparableSymbol[]{new RealSymbol(i.doubleValue()), this};
        }
        if (o instanceof RealSymbol) {
            return new IComparableSymbol[]{o, this};
        }
        if (o instanceof BooleanSymbol) {
            BooleanSymbol b = (BooleanSymbol)o;
            return new IComparableSymbol[]{new IntSymbol(b.intValue()), new IntSymbol(this.intValue())};
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            return new IComparableSymbol[]{new RealSymbol(n.doubleValue()), new RealSymbol(this.doubleValue())};
        }
        return super.coerce(o);
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof RealSymbol) {
            RealSymbol rs = (RealSymbol)o;
            Double d = this.doubleValue();
            return d.compareTo(rs.doubleValue());
        }
        if (o instanceof IntSymbol) {
            IntSymbol i = (IntSymbol)o;
            return Double.compare(this.doubleValue(), i.doubleValue());
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }

    public static class AnyRealSymbol
    extends RealSymbol {
        public AnyRealSymbol() {
            super("ANY");
        }

        @Override
        public boolean matches(ISymbol symbol, IMatchContext ctx) {
            if (symbol instanceof RealSymbol) {
                ctx.put(this, symbol);
                return true;
            }
            return super.matches(symbol, ctx);
        }

        @Override
        public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
            return super.coerce(o);
        }

        @Override
        public int compareTo(IComparableSymbol o) {
            if (o instanceof AnyRealSymbol) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
            return this.matches(symbol, ctx);
        }
    }
}

