/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util;

import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BinEncoder {
    public final int BitN;
    public final int MAX_VALUE;

    public BinEncoder(int bitN) {
        this.BitN = bitN;
        this.MAX_VALUE = (2 << this.BitN - 1) - 1;
    }

    public char decodeChar(String csStr) {
        return this.decodeChar(csStr, null);
    }

    public char decodeChar(String csStr, String xsStr) {
        char[] xs;
        int c = 0;
        char[] cs = csStr.toCharArray();
        char[] cArray = xs = xsStr == null ? null : xsStr.toCharArray();
        assert (this.BitN == cs.length);
        assert (this.BitN == xs.length);
        for (int i = this.BitN - 1; i >= 0; --i) {
            c <<= 1;
            if (cs[i] != '1' && (cs[i] != 'X' || xs == null || xs[i] != '1')) continue;
            ++c;
        }
        return (char)c;
    }

    public String encodeChar(char c) {
        return this.encodeChar((int)c);
    }

    public String encodeChar(int c) {
        if (c > this.MAX_VALUE) {
            c = this.MAX_VALUE;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.BitN; ++i) {
            buff.append(Integer.toString(c % 2));
            c >>= 1;
        }
        return buff.toString();
    }

    public IAutomaton encodeCharset(char min, char max) {
        return this.encodeCharset((int)min, (int)max);
    }

    private IAutomaton encodeCharInFSA(int b, boolean lt) {
        IntState initState = new IntState(b);
        Automaton fsa = new Automaton((IState)initState, Collections.emptySet(), Collections.emptySet());
        HashSet<IntState> states = new HashSet<IntState>();
        states.add(initState);
        Set<ITransition> transitions = fsa.getTransitions();
        for (int i = 0; i < this.BitN; ++i) {
            HashSet<IntState> newStates = new HashSet<IntState>();
            boolean cont = false;
            for (IntState s : states) {
                int c = s.getValue();
                int p = c % 2;
                if (p < 0) {
                    p = -p;
                }
                int d = c - p >> 1;
                IntState sd = new IntState(d);
                newStates.add(sd);
                Transition t = new Transition(s, sd, new IntSymbol(p));
                if (!transitions.contains(t)) {
                    transitions.add(t);
                    cont = true;
                }
                if (!lt) continue;
                int p2 = p == 0 ? 1 : 0;
                int d2 = c - p2 >> 1;
                IntState sd2 = new IntState(d2);
                newStates.add(sd2);
                Transition t2 = new Transition(s, sd2, new IntSymbol(p2));
                if (transitions.contains(t2)) continue;
                transitions.add(t2);
                cont = true;
            }
            states.addAll(newStates);
            if (!cont) break;
        }
        fsa.getFinalStates().add(new IntState(0));
        if (lt) {
            for (IntState s : states) {
                if (s.getValue() <= 0) continue;
                fsa.getFinalStates().add(s);
            }
        }
        return fsa;
    }

    public IAutomaton encodeCharsetInFSA(int min, int max) {
        if (min == 0) {
            IAutomaton maxFsa = this.encodeCharInFSA(max, true);
            return maxFsa;
        }
        IAutomaton minFsa = this.encodeCharInFSA(min - 1, true);
        IAutomaton minFsaInv = Automatons.createComplement(minFsa);
        minFsaInv = Automatons.expand(minFsaInv, Arrays.asList(new IntSymbol(0), new IntSymbol(1)));
        IAutomaton maxFsa = this.encodeCharInFSA(max, true);
        IAutomaton r = Automatons.createIntersection(minFsaInv, maxFsa);
        return r;
    }

    public IAutomaton encodeCharset(int min, int max) {
        if (max > this.MAX_VALUE) {
            max = this.MAX_VALUE;
        }
        IAutomaton a = this.encodeCharsetInFSA(min, max);
        ISymbol[] l = new ISymbol[this.BitN];
        Variable v = new Variable("x");
        for (int i = 0; i < this.BitN; ++i) {
            l[i] = v;
        }
        Automaton b = Automatons.createAutomaton(l);
        IAutomaton c = Automatons.createIntersection(a, b);
        Automatons.eliminateEpsilonTransitions(c);
        return c;
    }

    private static class IntState
    extends State {
        private int N;

        public IntState(int n) {
            super(Integer.toString(n));
            this.N = n;
        }

        int getValue() {
            return this.N;
        }
    }
}

