/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.automaton.util.collections.IntHashMap;
import com.ibm.wala.automaton.util.collections.SimpleIntSequence;
import com.ibm.wala.automaton.util.collections.TinyOrderdIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BinTreeIntHashMap<T>
implements IntHashMap<T> {
    private int heightL = 0;
    private int heightR = 0;
    private Node<T> root;

    public void traverseInOrder(Node<T> node, Visitor<T> v) {
        if (node == null) {
            return;
        }
        if (((Node)node).left != null) {
            this.traverseInOrder(((Node)node).left, v);
        }
        v.visit(node);
        if (((Node)node).right != null) {
            this.traverseInOrder(((Node)node).right, v);
        }
    }

    private T find(int key) {
        Node node = this.root;
        while (node != null) {
            int i = node.index;
            if (i == key) {
                return (T)node.data;
            }
            if (i > key) {
                node = node.right;
                continue;
            }
            node = node.left;
        }
        return null;
    }

    private T insert(int key, T val) {
        Node node = this.root;
        if (node == null) {
            this.root = new Node();
            ((Node)this.root).index = key;
            ((Node)this.root).data = val;
            return null;
        }
        while (true) {
            if (node.index == key) {
                Object tmp = node.data;
                node.data = val;
                return (T)tmp;
            }
            if (node.index > key) {
                if (node.left == null) {
                    node.left = new Node();
                    node.left.index = key;
                    node.left.data = val;
                    ++this.heightL;
                    continue;
                }
                node = node.left;
                continue;
            }
            if (node.index >= key) continue;
            if (node.right == null) {
                node.right = new Node();
                node.right.index = key;
                node.right.data = val;
                ++this.heightR;
                continue;
            }
            node = node.right;
        }
    }

    @Override
    public boolean containsKey(int key) {
        if (this.root == null) {
            return false;
        }
        return this.find(key) != null;
    }

    @Override
    public boolean containsValue(T value) {
        ValueFinder v = new ValueFinder(value);
        try {
            this.traverseInOrder(this.root, v);
        }
        catch (ValueFound e) {
            return true;
        }
        return false;
    }

    @Override
    public Set<IntHashMap.Entry<T>> entrySet() {
        EntrySetMaker v = new EntrySetMaker();
        this.traverseInOrder(this.root, v);
        return v.set;
    }

    @Override
    public T get(int key) {
        return this.find(key);
    }

    @Override
    public boolean isEmpty() {
        NonNullFinder v = new NonNullFinder();
        try {
            this.traverseInOrder(this.root, v);
        }
        catch (ValueFound e) {
            return true;
        }
        return false;
    }

    @Override
    public IntSet keySet() {
        KeySetMaker v = new KeySetMaker();
        this.traverseInOrder(this.root, v);
        return new TinyOrderdIntSet(v.set.toArray());
    }

    @Override
    public T put(int key, T value) {
        return this.insert(key, value);
    }

    @Override
    public void putAll(IntHashMap<? extends T> m) {
        IntHashMap.Entry[] a = new IntHashMap.Entry[1];
        a = m.entrySet().toArray(a);
        int pivot = a.length / 2;
        IntHashMap.Entry e = a[pivot];
        this.insert(e.getKey(), e.getValue());
        int dist = 1;
        int len = a.length;
        while (pivot + dist < a.length) {
            int i = pivot - dist;
            if (i >= 0) {
                e = a[i];
                this.insert(e.getKey(), e.getValue());
            }
            if ((i = pivot + dist) < len) {
                e = a[i];
                this.insert(e.getKey(), e.getValue());
            }
            ++dist;
        }
    }

    @Override
    public T remove(int key) {
        return this.insert(key, null);
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public Collection<T> values() {
        ValueCollector v = new ValueCollector();
        this.traverseInOrder(this.root, v);
        return v.set;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("{");
        Iterator<IntHashMap.Entry<T>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            IntHashMap.Entry<T> entry = i.next();
            buff.append(entry.getKey() + "=>" + entry.getValue());
            if (!i.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("}");
        return buff.toString();
    }

    private class KeySetMaker
    implements Visitor<T> {
        private final SimpleIntSequence set = new SimpleIntSequence();

        private KeySetMaker() {
        }

        @Override
        public void visit(Node<T> node) {
            this.set.append(node.index);
        }
    }

    private class EntrySetMaker
    implements Visitor<T> {
        private final Set<IntHashMap.Entry<T>> set = new HashSet();

        private EntrySetMaker() {
        }

        @Override
        public void visit(Node<T> node) {
            this.set.add(new EntryImpl(node.index, node.data));
        }
    }

    protected class EntryImpl
    implements IntHashMap.Entry<T> {
        private final int key;
        private T val;

        protected EntryImpl(int k, T v) {
            this.key = k;
            this.val = v;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.val;
        }

        @Override
        public T setValue(T v) {
            BinTreeIntHashMap.this.put(this.key, v);
            Object ret = this.val;
            this.val = v;
            return ret;
        }
    }

    static class ValueFound
    extends RuntimeException {
        private static final long serialVersionUID = -1086667249766106359L;

        ValueFound() {
        }
    }

    private class ValueCollector
    implements Visitor<T> {
        private Collection<T> set = new HashSet();

        private ValueCollector() {
        }

        @Override
        public void visit(Node<T> node) {
            if (node.data != null) {
                this.set.add(node.data);
            }
        }
    }

    private class NonNullFinder
    implements Visitor<T> {
        private NonNullFinder() {
        }

        @Override
        public void visit(Node<T> node) {
            if (node.data != null) {
                throw new ValueFound();
            }
        }
    }

    private class ValueFinder
    implements Visitor<T> {
        private final T val;

        public ValueFinder(T val) {
            this.val = val;
        }

        @Override
        public void visit(Node<T> node) {
            if (node.data == this.val) {
                throw new ValueFound();
            }
            if (node.data.equals(this.val)) {
                throw new ValueFound();
            }
        }
    }

    public static interface Visitor<E> {
        public void visit(Node<E> var1);
    }

    public static class Node<E> {
        private int index;
        private E data;
        private Node<E> left;
        private Node<E> right;

        public E getData() {
            return this.data;
        }

        public void setData(E data) {
            this.data = data;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Node<E> getLeft() {
            return this.left;
        }

        public void setLeft(Node<E> left) {
            this.left = left;
        }

        public Node<E> getRight() {
            return this.right;
        }

        public void setRight(Node<E> right) {
            this.right = right;
        }
    }
}

