/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.pointers;

import com.ibm.wala.analysis.pointers.HeapGraphImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.IntFunction;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class BasicHeapGraph
extends HeapGraphImpl {
    private static final boolean VERBOSE = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final MutableSparseIntSetFactory factory = new MutableSparseIntSetFactory();
    private final NumberedGraph<Object> G;
    private final CallGraph callGraph;

    public BasicHeapGraph(final PointerAnalysis<InstanceKey> P, CallGraph callGraph) throws NullPointerException {
        super(P);
        this.callGraph = callGraph;
        final OrdinalSetMapping<PointerKey> pointerKeys = this.getPointerKeys();
        NumberedNodeManager<Object> nodeMgr = new NumberedNodeManager<Object>(){

            public Iterator<Object> iterator() {
                return new CompoundIterator(pointerKeys.iterator(), P.getInstanceKeyMapping().iterator());
            }

            public int getNumberOfNodes() {
                return pointerKeys.getSize() + P.getInstanceKeyMapping().getSize();
            }

            public void addNode(Object n) {
                Assertions.UNREACHABLE();
            }

            public void removeNode(Object n) {
                Assertions.UNREACHABLE();
            }

            public int getNumber(Object N) {
                int inumber;
                if (N instanceof PointerKey) {
                    return pointerKeys.getMappedIndex((Object)((PointerKey)N));
                }
                if (!(N instanceof InstanceKey)) {
                    Assertions.UNREACHABLE((String)N.getClass().toString());
                }
                return (inumber = P.getInstanceKeyMapping().getMappedIndex((Object)((InstanceKey)N))) == -1 ? -1 : inumber + pointerKeys.getMaximumIndex() + 1;
            }

            public Object getNode(int number) {
                if (number > pointerKeys.getMaximumIndex()) {
                    return P.getInstanceKeyMapping().getMappedObject(number - pointerKeys.getSize());
                }
                return pointerKeys.getMappedObject(number);
            }

            public int getMaxNumber() {
                return this.getNumberOfNodes() - 1;
            }

            public boolean containsNode(Object n) {
                return this.getNumber(n) != -1;
            }

            public Iterator<Object> iterateNodes(IntSet s) {
                return new NumberedNodeIterator(s, (NumberedNodeManager)this);
            }
        };
        IBinaryNaturalRelation pred = this.computePredecessors(nodeMgr);
        IntFunction<Object> toNode = new IntFunction<Object>((NumberedNodeManager)nodeMgr){
            final /* synthetic */ NumberedNodeManager val$nodeMgr;
            {
                this.val$nodeMgr = numberedNodeManager;
            }

            public Object apply(int i) {
                return this.val$nodeMgr.getNode(i);
            }
        };
        this.G = new AbstractNumberedGraph<Object>((NumberedNodeManager)nodeMgr, pred, (IntFunction)toNode){
            private final NumberedEdgeManager<Object> edgeMgr = new NumberedEdgeManager<Object>(){

                public Iterator<Object> getPredNodes(Object N) {
                    int n = val$nodeMgr.getNumber(N);
                    IntSet p = val$pred.getRelated(n);
                    if (p == null) {
                        return EmptyIterator.instance();
                    }
                    return new IntMapIterator(p.intIterator(), val$toNode);
                }

                public IntSet getPredNodeNumbers(Object N) {
                    int n = val$nodeMgr.getNumber(N);
                    IntSet p = val$pred.getRelated(n);
                    if (p != null) {
                        return p;
                    }
                    return IntSetUtil.make();
                }

                public int getPredNodeCount(Object N) {
                    int n = val$nodeMgr.getNumber(N);
                    return val$pred.getRelatedCount(n);
                }

                public Iterator<Object> getSuccNodes(Object N) {
                    int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, (NumberedNodeManager<Object>)val$nodeMgr);
                    if (succ == null) {
                        return EmptyIterator.instance();
                    }
                    MutableSparseIntSet s = factory.make(succ);
                    return new IntMapIterator(s.intIterator(), val$toNode);
                }

                public IntSet getSuccNodeNumbers(Object N) {
                    int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, (NumberedNodeManager<Object>)val$nodeMgr);
                    if (succ == null) {
                        return IntSetUtil.make();
                    }
                    return IntSetUtil.make((int[])succ);
                }

                public int getSuccNodeCount(Object N) {
                    int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, (NumberedNodeManager<Object>)val$nodeMgr);
                    return succ == null ? 0 : succ.length;
                }

                public void addEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                }

                public void removeEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                }

                public void removeAllIncidentEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                public void removeIncomingEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                public void removeOutgoingEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                public boolean hasEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                    return false;
                }
            };
            final /* synthetic */ NumberedNodeManager val$nodeMgr;
            final /* synthetic */ IBinaryNaturalRelation val$pred;
            final /* synthetic */ IntFunction val$toNode;
            {
                this.val$nodeMgr = numberedNodeManager;
                this.val$pred = iBinaryNaturalRelation;
                this.val$toNode = intFunction;
            }

            protected NumberedNodeManager<Object> getNodeManager() {
                return this.val$nodeMgr;
            }

            protected NumberedEdgeManager<Object> getEdgeManager() {
                return this.edgeMgr;
            }
        };
    }

    private OrdinalSetMapping<PointerKey> getPointerKeys() {
        MutableMapping result = MutableMapping.make();
        for (PointerKey p : this.getPointerAnalysis().getPointerKeys()) {
            result.add((Object)p);
        }
        return result;
    }

    private int[] computeSuccNodeNumbers(Object N, NumberedNodeManager<Object> nodeManager) {
        if (N instanceof PointerKey) {
            PointerKey P = (PointerKey)N;
            OrdinalSet S = this.getPointerAnalysis().getPointsToSet(P);
            int[] result = new int[S.size()];
            int i = 0;
            Iterator it = S.iterator();
            while (it.hasNext()) {
                result[i] = nodeManager.getNumber(it.next());
                ++i;
            }
            return result;
        }
        if (N instanceof InstanceKey) {
            InstanceKey I = (InstanceKey)N;
            TypeReference T = I.getConcreteType().getReference();
            if (T == null) assert (T != null) : "null concrete type from " + I.getClass();
            if (T.isArrayType()) {
                PointerKey p = this.getHeapModel().getPointerKeyForArrayContents(I);
                if (p == null || !nodeManager.containsNode((Object)p)) {
                    return null;
                }
                return new int[]{nodeManager.getNumber((Object)p)};
            }
            IClass klass = this.getHeapModel().getClassHierarchy().lookupClass(T);
            if (klass == null) assert (klass != null) : "null klass for type " + T;
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            for (IField f : klass.getAllInstanceFields()) {
                PointerKey p;
                if (f.getReference().getFieldType().isPrimitiveType() || (p = this.getHeapModel().getPointerKeyForInstanceField(I, f)) == null || !nodeManager.containsNode((Object)p)) continue;
                result.add(nodeManager.getNumber((Object)p));
            }
            return result.toIntArray();
        }
        Assertions.UNREACHABLE((String)("Unexpected type: " + N.getClass()));
        return null;
    }

    private IBinaryNaturalRelation computePredecessors(NumberedNodeManager<Object> nodeManager) {
        BasicNaturalRelation R = new BasicNaturalRelation(new byte[]{0}, 0);
        this.computePredecessorsForNonLocals(nodeManager, R);
        this.computePredecessorsForLocals(nodeManager, R);
        return R;
    }

    private void computePredecessorsForNonLocals(NumberedNodeManager<Object> nodeManager, BasicNaturalRelation R) {
        for (int i = nodeManager.getMaxNumber(); i >= 0; --i) {
            int[] succ;
            Object n = nodeManager.getNode(i);
            if (n instanceof LocalPointerKey || (succ = this.computeSuccNodeNumbers(n, nodeManager)) == null) continue;
            for (int z = 0; z < succ.length; ++z) {
                int j = succ[z];
                R.add(j, i);
            }
        }
    }

    private void computePredecessorsForLocals(NumberedNodeManager<Object> nodeManager, BasicNaturalRelation R) {
        ArrayList<LocalPointerKey> list = new ArrayList<LocalPointerKey>();
        for (Object n : nodeManager) {
            if (!(n instanceof LocalPointerKey)) continue;
            list.add((LocalPointerKey)n);
        }
        Object[] arr = list.toArray();
        Arrays.sort(arr, new LocalPointerComparator());
        for (int i = 0; i < arr.length; ++i) {
            LocalPointerKey n = (LocalPointerKey)arr[i];
            int num = nodeManager.getNumber((Object)n);
            int[] succ = this.computeSuccNodeNumbers(n, nodeManager);
            if (succ == null) continue;
            for (int z = 0; z < succ.length; ++z) {
                int j = succ[z];
                R.add(j, num);
            }
        }
    }

    public int getNumber(Object N) {
        return this.G.getNumber(N);
    }

    public Object getNode(int number) {
        return this.G.getNode(number);
    }

    public int getMaxNumber() {
        return this.G.getMaxNumber();
    }

    public Iterator<Object> iterator() {
        return this.G.iterator();
    }

    public int getNumberOfNodes() {
        return this.G.getNumberOfNodes();
    }

    public Iterator<Object> getPredNodes(Object N) {
        return this.G.getPredNodes(N);
    }

    public int getPredNodeCount(Object N) {
        return this.G.getPredNodeCount(N);
    }

    public Iterator<Object> getSuccNodes(Object N) {
        return this.G.getSuccNodes(N);
    }

    public int getSuccNodeCount(Object N) {
        return this.G.getSuccNodeCount(N);
    }

    public void addNode(Object n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public void removeNode(Object n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public void addEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public void removeEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public boolean hasEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    public void removeAllIncidentEdges(Object node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean containsNode(Object N) {
        return this.G.containsNode(N);
    }

    public String toString() {
        Object node;
        int i;
        StringBuffer result = new StringBuffer();
        result.append("Nodes:\n");
        for (i = 0; i <= this.getMaxNumber(); ++i) {
            node = this.getNode(i);
            if (node == null) continue;
            result.append(i).append("  ").append(node).append("\n");
        }
        result.append("Edges:\n");
        for (i = 0; i <= this.getMaxNumber(); ++i) {
            node = this.getNode(i);
            if (node == null) continue;
            result.append(i).append(" -> ");
            Iterator<Object> it = this.getSuccNodes(node);
            while (it.hasNext()) {
                Object s = it.next();
                result.append(this.getNumber(s)).append(" ");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public void removeIncomingEdges(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public void removeOutgoingEdges(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public IntSet getSuccNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    private final class LocalPointerComparator
    implements Comparator<Object> {
        private LocalPointerComparator() {
        }

        @Override
        public int compare(Object arg1, Object arg2) {
            LocalPointerKey o1 = (LocalPointerKey)arg1;
            LocalPointerKey o2 = (LocalPointerKey)arg2;
            if (o1.getNode().equals(o2.getNode())) {
                return o1.getValueNumber() - o2.getValueNumber();
            }
            return BasicHeapGraph.this.callGraph.getNumber(o1.getNode()) - BasicHeapGraph.this.callGraph.getNumber(o2.getNode());
        }
    }
}

