/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.ssa;

import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Iterator;

public abstract class SSAInference<T extends IVariable<?>>
extends DefaultFixedPointSolver<T> {
    static final boolean DEBUG = false;
    private IR ir;
    private SymbolTable symbolTable;
    private IVariable[] vars;

    protected void init(IR ir, VariableFactory varFactory, OperatorFactory<T> opFactory) {
        this.ir = ir;
        this.symbolTable = ir.getSymbolTable();
        this.createVariables(varFactory);
        this.createEquations(opFactory);
    }

    private void createEquations(OperatorFactory<T> opFactory) {
        SSAInstruction s;
        SSAInstruction[] instructions = this.ir.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            s = instructions[i];
            this.makeEquationForInstruction(opFactory, s);
        }
        Iterator<? extends SSAInstruction> it = this.ir.iteratePhis();
        while (it.hasNext()) {
            s = it.next();
            this.makeEquationForInstruction(opFactory, s);
        }
        it = this.ir.iteratePis();
        while (it.hasNext()) {
            s = it.next();
            this.makeEquationForInstruction(opFactory, s);
        }
        it = this.ir.iterateCatchInstructions();
        while (it.hasNext()) {
            s = it.next();
            this.makeEquationForInstruction(opFactory, s);
        }
    }

    private void makeEquationForInstruction(OperatorFactory<T> opFactory, SSAInstruction s) {
        AbstractOperator<T> op;
        if (s != null && s.hasDef() && (op = opFactory.get(s)) != null) {
            T def = this.getVariable(s.getDef());
            if (op instanceof NullaryOperator) {
                this.newStatement((IVariable)def, (NullaryOperator)op, false, false);
            } else {
                int n = s.getNumberOfUses();
                IVariable[] uses = this.makeStmtRHS(n);
                for (int j = 0; j < n; ++j) {
                    if (s.getUse(j) <= -1) continue;
                    uses[j] = this.getVariable(s.getUse(j));
                    assert (uses[j] != null);
                }
                this.newStatement((IVariable)def, (AbstractOperator)op, uses, false, false);
            }
        }
    }

    private void createVariables(VariableFactory factory) {
        this.vars = new IVariable[this.symbolTable.getMaxValueNumber() + 1];
        for (int i = 1; i < this.vars.length; ++i) {
            this.vars[i] = factory.makeVariable(i);
        }
    }

    protected T getVariable(int valueNumber) {
        if (valueNumber < 0) {
            throw new IllegalArgumentException("Illegal valueNumber " + valueNumber);
        }
        assert (this.vars != null) : "null vars array";
        return (T)this.vars[valueNumber];
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Type inference : \n");
        for (int i = 0; i < this.vars.length; ++i) {
            result.append("v").append(i).append("  ").append(this.vars[i]).append("\n");
        }
        return result.toString();
    }

    public static interface VariableFactory {
        public IVariable makeVariable(int var1);
    }

    public static interface OperatorFactory<T extends IVariable> {
        public AbstractOperator<T> get(SSAInstruction var1);
    }
}

