/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeDynamicInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

public class LambdaSummaryClass
extends SyntheticClass {
    private static WeakHashMap<BootstrapMethodsReader.BootstrapMethod, LambdaSummaryClass> summaries = new WeakHashMap();
    private final SSAInvokeDynamicInstruction invoke;
    private final Map<Atom, IField> fields;
    private final Map<Selector, IMethod> methods;

    public static LambdaSummaryClass findOrCreate(CGNode caller, SSAInvokeDynamicInstruction inst) {
        if (!summaries.containsKey(inst.getBootstrap())) {
            String bootstrapCls = caller.getMethod().getDeclaringClass().getName().toString().replace("/", "$").substring(1);
            int bootstrapIndex = inst.getBootstrap().getIndexInClassFile();
            TypeReference ref = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Lwala/lambda$" + bootstrapCls + "$" + bootstrapIndex);
            LambdaSummaryClass cls = new LambdaSummaryClass(ref, caller.getClassHierarchy(), inst);
            caller.getClassHierarchy().addClass(cls);
            summaries.put(inst.getBootstrap(), cls);
        }
        return summaries.get(inst.getBootstrap());
    }

    public LambdaSummaryClass(TypeReference T, IClassHierarchy cha, SSAInvokeDynamicInstruction invoke) {
        super(T, cha);
        this.invoke = invoke;
        this.fields = this.makeFields();
        this.methods = Collections.singletonMap(this.trampoline().getSelector(), this.makeTrampoline());
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public int getModifiers() throws UnsupportedOperationException {
        return 48;
    }

    @Override
    public IClass getSuperclass() {
        return this.getClassHierarchy().getRootClass();
    }

    @Override
    public Collection<? extends IClass> getDirectInterfaces() {
        return Collections.singleton(this.getClassHierarchy().lookupClass(this.invoke.getDeclaredResultType()));
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        IClass iface = this.getClassHierarchy().lookupClass(this.invoke.getDeclaredResultType());
        HashSet result = HashSetFactory.make(iface.getAllImplementedInterfaces());
        result.add(iface);
        return result;
    }

    @Override
    public IMethod getMethod(Selector selector) {
        return this.methods.get(selector);
    }

    @Override
    public IField getField(Atom name) {
        return this.fields.get(name);
    }

    @Override
    public IMethod getClassInitializer() {
        return null;
    }

    @Override
    public Collection<IMethod> getDeclaredMethods() {
        return this.methods.values();
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        return this.fields.values();
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getAllFields() {
        return this.getAllInstanceFields();
    }

    @Override
    public Collection<IMethod> getAllMethods() {
        return this.methods.values();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        return this.fields.values();
    }

    private Map<Atom, IField> makeFields() {
        HashMap result = HashMapFactory.make();
        int i = 0;
        while (i < this.invoke.getNumberOfParameters()) {
            final int yuck = i++;
            result.put(Atom.findOrCreateUnicodeAtom("c" + yuck), new IField(){

                @Override
                public IClass getDeclaringClass() {
                    return LambdaSummaryClass.this;
                }

                @Override
                public Atom getName() {
                    return Atom.findOrCreateUnicodeAtom("c" + yuck);
                }

                @Override
                public Collection<Annotation> getAnnotations() {
                    return Collections.emptySet();
                }

                @Override
                public IClassHierarchy getClassHierarchy() {
                    return LambdaSummaryClass.this.getClassHierarchy();
                }

                @Override
                public TypeReference getFieldTypeReference() {
                    return LambdaSummaryClass.this.invoke.getDeclaredTarget().getParameterType(yuck);
                }

                @Override
                public FieldReference getReference() {
                    return FieldReference.findOrCreate(LambdaSummaryClass.this.getReference(), this.getName(), this.getFieldTypeReference());
                }

                @Override
                public boolean isFinal() {
                    return true;
                }

                @Override
                public boolean isPrivate() {
                    return true;
                }

                @Override
                public boolean isProtected() {
                    return false;
                }

                @Override
                public boolean isPublic() {
                    return false;
                }

                @Override
                public boolean isStatic() {
                    return false;
                }

                @Override
                public boolean isVolatile() {
                    return false;
                }
            });
        }
        return result;
    }

    private MethodReference trampoline() {
        try {
            return MethodReference.findOrCreate(this.getReference(), this.invoke.getDeclaredTarget().getName(), Descriptor.findOrCreateUTF8(this.getLambdaDeclaredSignature()));
        }
        catch (InvalidClassFileException | IllegalArgumentException e) {
            assert (false) : e;
            return null;
        }
    }

    private String getLambdaCalleeClass() throws IllegalArgumentException, InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return "L" + this.invoke.getBootstrap().getCP().getCPHandleClass(cpIndex);
    }

    private String getLambdaCalleeName() throws IllegalArgumentException, InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return this.invoke.getBootstrap().getCP().getCPHandleName(cpIndex);
    }

    private String getLambdaCalleeSignature() throws IllegalArgumentException, InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return this.invoke.getBootstrap().getCP().getCPHandleType(cpIndex);
    }

    private String getLambdaDeclaredSignature() throws IllegalArgumentException, InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(0);
        return this.invoke.getBootstrap().getCP().getCPMethodType(cpIndex);
    }

    private int getLambdaCalleeKind() throws IllegalArgumentException, InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return this.invoke.getBootstrap().getCP().getCPHandleKind(cpIndex);
    }

    private IMethod makeTrampoline() {
        MethodSummary summary;
        MethodReference ref;
        block13: {
            SSAInstructionFactory insts = this.getClassLoader().getInstructionFactory();
            ref = this.trampoline();
            summary = new MethodSummary(ref);
            int inst = 0;
            int args = this.invoke.getNumberOfParameters();
            int v = args + 1;
            for (int i = 0; i < this.invoke.getNumberOfParameters(); ++i) {
                Atom f = Atom.findOrCreateUnicodeAtom("c" + i);
                summary.addStatement(insts.GetInstruction(inst++, v++, 1, this.getField(f).getReference()));
            }
            try {
                IInvokeInstruction.Dispatch code;
                MethodReference callee = MethodReference.findOrCreate(ClassLoaderReference.Application, this.getLambdaCalleeClass(), this.getLambdaCalleeName(), this.getLambdaCalleeSignature());
                int kind = this.getLambdaCalleeKind();
                switch (kind) {
                    case 5: {
                        code = IInvokeInstruction.Dispatch.VIRTUAL;
                        break;
                    }
                    case 6: {
                        code = IInvokeInstruction.Dispatch.STATIC;
                        break;
                    }
                    case 7: {
                        code = IInvokeInstruction.Dispatch.SPECIAL;
                        break;
                    }
                    case 9: {
                        code = IInvokeInstruction.Dispatch.INTERFACE;
                        break;
                    }
                    default: {
                        throw new Error("unexpected dynamic invoke type " + kind);
                    }
                }
                int numParams = this.getClassHierarchy().resolveMethod(callee).getNumberOfParameters();
                int[] params = new int[numParams];
                for (int i = 0; i < this.invoke.getNumberOfParameters(); ++i) {
                    params[i] = args + i + 1;
                }
                int n = 2;
                for (int i = this.invoke.getNumberOfParameters(); i < numParams; ++i) {
                    params[i] = n++;
                }
                if (callee.getReturnType().equals(TypeReference.Void)) {
                    summary.addStatement(insts.InvokeInstruction(inst++, params, v++, CallSiteReference.make(inst, callee, (IInvokeInstruction.IDispatch)code), null));
                } else {
                    int ret = v++;
                    summary.addStatement(insts.InvokeInstruction(inst++, ret, params, v++, CallSiteReference.make(inst, callee, (IInvokeInstruction.IDispatch)code), null));
                    summary.addStatement(insts.ReturnInstruction(inst++, ret, callee.getReturnType().isPrimitiveType()));
                }
            }
            catch (InvalidClassFileException | IllegalArgumentException e) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError((Object)e.toString());
            }
        }
        SummarizedMethod method = new SummarizedMethod(ref, summary, this);
        return method;
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return Collections.emptySet();
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }
}

