/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.util.strings.UTF8Convert;
import java.util.Map;

public final class Descriptor {
    private static final Map<Key, Descriptor> map = HashMapFactory.make();
    private final Key key;

    public static Descriptor findOrCreate(TypeName[] parameters, TypeName returnType) {
        Key k;
        Descriptor result;
        if (returnType == null) {
            throw new IllegalArgumentException("null returnType");
        }
        if (parameters != null && parameters.length == 0) {
            parameters = null;
        }
        if ((result = map.get(k = new Key(returnType, parameters))) == null) {
            result = new Descriptor(k);
            map.put(k, result);
        }
        return result;
    }

    public static Descriptor findOrCreate(Language l, ImmutableByteArray b) throws IllegalArgumentException {
        TypeName[] parameters;
        TypeName returnType = StringStuff.parseForReturnTypeName(l, b);
        Key k = new Key(returnType, parameters = StringStuff.parseForParameterNames(l, b));
        Descriptor result = map.get(k);
        if (result == null) {
            result = new Descriptor(k);
            map.put(k, result);
        }
        return result;
    }

    public static Descriptor findOrCreate(ImmutableByteArray b) throws IllegalArgumentException {
        return Descriptor.findOrCreate(Language.JAVA, b);
    }

    public static Descriptor findOrCreateUTF8(String s) throws IllegalArgumentException {
        return Descriptor.findOrCreateUTF8(Language.JAVA, s);
    }

    public static Descriptor findOrCreateUTF8(Language l, String s) throws IllegalArgumentException {
        byte[] b = UTF8Convert.toUTF8(s);
        return Descriptor.findOrCreate(l, new ImmutableByteArray(b));
    }

    private Descriptor(Key key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key.toString();
    }

    public String toUnicodeString() {
        return this.key.toUnicodeString();
    }

    public TypeName getReturnType() {
        return this.key.returnType;
    }

    public TypeName[] getParameters() {
        return this.key.parameters;
    }

    public int getNumberOfParameters() {
        return this.key.parameters == null ? 0 : this.key.parameters.length;
    }

    private static class Key {
        private final TypeName returnType;
        private final TypeName[] parameters;
        private final int hashCode;

        Key(TypeName returnType, TypeName[] parameters) {
            this.returnType = returnType;
            this.parameters = parameters;
            if (parameters != null) assert (parameters.length > 0);
            this.hashCode = this.computeHashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public int computeHashCode() {
            int result = this.returnType.hashCode() * 5309;
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    result += this.parameters[i].hashCode() * (0x14CB ^ i);
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            assert (obj instanceof Key);
            Key other = (Key)obj;
            if (!this.returnType.equals(other.returnType)) {
                return false;
            }
            if (this.parameters == null) {
                return other.parameters == null;
            }
            if (other.parameters == null) {
                return false;
            }
            if (this.parameters.length != other.parameters.length) {
                return false;
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i].equals(other.parameters[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("(");
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    TypeName p = this.parameters[i];
                    result.append(p);
                    this.appendSemicolonIfNeeded(result, p);
                }
            }
            result.append(")");
            result.append(this.returnType);
            this.appendSemicolonIfNeeded(result, this.returnType);
            return result.toString();
        }

        public String toUnicodeString() {
            StringBuffer result = new StringBuffer();
            result.append("(");
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    TypeName p = this.parameters[i];
                    result.append(p.toUnicodeString());
                    this.appendSemicolonIfNeeded(result, p);
                }
            }
            result.append(")");
            result.append(this.returnType);
            this.appendSemicolonIfNeeded(result, this.returnType);
            return result.toString();
        }

        private void appendSemicolonIfNeeded(StringBuffer result, TypeName p) {
            if (p.isArrayType()) {
                TypeName e = p.getInnermostElementType();
                String x = e.toUnicodeString();
                if (x.startsWith("L") || x.startsWith("P")) {
                    result.append(";");
                }
            } else {
                String x = p.toUnicodeString();
                if (x.startsWith("L") || x.startsWith("P")) {
                    result.append(";");
                }
            }
        }
    }
}

