/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;

public final class FieldReference
extends MemberReference {
    private static final boolean DEBUG = false;
    private static final HashMap<Key, FieldReference> dictionary = HashMapFactory.make();
    private final TypeReference fieldType;

    @Override
    public String getSignature() {
        return this.getDeclaringClass().getName() + "." + this.getName() + " " + this.getFieldType().getName();
    }

    public static synchronized FieldReference findOrCreate(TypeReference tref, Atom mn, TypeReference fieldType) {
        if (tref == null) {
            throw new IllegalArgumentException("null tref");
        }
        Key key = new Key(tref, mn, fieldType);
        FieldReference val = dictionary.get(key);
        if (val != null) {
            return val;
        }
        val = new FieldReference(key, fieldType);
        dictionary.put(key, val);
        return val;
    }

    public static FieldReference findOrCreate(ClassLoaderReference loader, String classType, String fieldName, String fieldType) throws IllegalArgumentException {
        TypeReference c = ShrikeUtil.makeTypeReference(loader, classType);
        TypeReference ft = ShrikeUtil.makeTypeReference(loader, fieldType);
        Atom name = Atom.findOrCreateUnicodeAtom(fieldName);
        return FieldReference.findOrCreate(c, name, ft);
    }

    private FieldReference(Key key, TypeReference fieldType) {
        super(key.type, key.name, key.hashCode());
        this.fieldType = fieldType;
    }

    public final TypeReference getFieldType() {
        return this.fieldType;
    }

    public final String toString() {
        return "< " + this.getDeclaringClass().getClassLoader().getName() + ", " + this.getDeclaringClass().getName() + ", " + this.getName() + ", " + this.fieldType + " >";
    }

    protected static class Key {
        final TypeReference type;
        final Atom name;
        private final TypeReference fieldType;

        Key(TypeReference type, Atom name, TypeReference fieldType) {
            this.type = type;
            this.name = name;
            this.fieldType = fieldType;
        }

        public final int hashCode() {
            return 7487 * this.type.hashCode() + this.name.hashCode();
        }

        public final boolean equals(Object other) {
            assert (other != null && this.getClass().equals(other.getClass()));
            Key that = (Key)other;
            return this.type.equals(that.type) && this.name.equals(that.name) && this.fieldType.equals(that.fieldType);
        }
    }
}

