/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ifa.tfidf;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ifa.tfidf.TfidfException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TfidfDictionary
implements Serializable {
    private static final long serialVersionUID = 8350490502309910954L;
    private HashMap<String, Integer> m_termCounts;
    private HashMap<String, Integer> m_documents;

    public TfidfDictionary() {
        this.m_termCounts = new HashMap();
        this.m_documents = new HashMap();
    }

    public TfidfDictionary(List<String> newDocs) {
        this.m_termCounts = new HashMap();
        this.m_documents = new HashMap();
        this.processNewDocs(newDocs);
    }

    public TfidfDictionary(File dictFile) throws TfidfException {
        this.m_termCounts = new HashMap();
        this.m_documents = new HashMap();
        try {
            for (String s : IOUtil.readFileIntoStringArray((File)dictFile)) {
                this.processNewDoc(s);
            }
        }
        catch (IOException e) {
            throw new TfidfException(e);
        }
    }

    public TfidfDictionary(HashMap<String, Integer> docs) {
        this.m_documents = docs;
        this.m_termCounts = new HashMap();
    }

    public HashMap<String, Integer> getTermCounts() {
        return this.m_termCounts;
    }

    public void setTermCounts(HashMap<String, Integer> termCounts) {
        this.m_termCounts = termCounts;
    }

    public HashMap<String, Integer> getDocuments() {
        return this.m_documents;
    }

    public void setDocuments(HashMap<String, Integer> documents) {
        this.m_documents = documents;
    }

    public void processNewDoc(String newDoc) {
        if (newDoc == null || newDoc.length() == 0) {
            return;
        }
        if (!this.m_documents.containsKey(newDoc)) {
            this.m_documents.put(newDoc, 1);
        } else {
            this.m_documents.put(newDoc, this.m_documents.get(newDoc) + 1);
        }
        for (String term : new HashSet<String>(Arrays.asList(newDoc.split(" ")))) {
            if (!this.m_termCounts.containsKey(term)) {
                this.m_termCounts.put(term, 1);
                continue;
            }
            this.m_termCounts.put(term, this.m_termCounts.get(term) + 1);
        }
    }

    public void processNewDocs(List<String> newDocs) {
        for (String doc : newDocs) {
            this.processNewDoc(doc);
        }
    }

    public int getTermCount(String term) {
        if (!this.m_termCounts.containsKey(term)) {
            int count = 0;
            for (String doc : this.m_documents.keySet()) {
                if (!Arrays.asList(doc.split(" ")).contains(doc)) continue;
                count += this.m_documents.get(doc).intValue();
            }
            this.m_termCounts.put(term, count);
        }
        return this.m_termCounts.get(term);
    }

    public int getNumDocuments() {
        int sum = 0;
        for (int i : this.m_documents.values()) {
            sum += i;
        }
        return sum;
    }

    public void save(File docFile) throws TfidfException {
        if (!docFile.exists()) {
            docFile.getParentFile().mkdirs();
        }
        try {
            IOUtil.write(this.m_documents.keySet(), (File)docFile);
        }
        catch (IOException e) {
            throw new TfidfException(e);
        }
    }
}

