/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.jaxwshandler;

import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.jaxwshandler.EndPointHandler;
import com.ibm.appscan.frameworks.jaxwshandler.utils.JAXWSToWSDLUtil;
import com.ibm.appscan.frameworks.jaxwshandler.utils.JAXWSUtils;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.wsdl.util.internal.WSDLReportingUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class JavaBeanEndPointHandler
extends EndPointHandler {
    private static final String PARAM_NAME = "param";
    private static int paramIndex;
    private ArrayList<String> sourceDirectoryList = null;
    final Logger logger = TaintLogger.i().getLogger();

    public JavaBeanEndPointHandler(ArrayList<String> sourceDirectoryList) {
        this.sourceDirectoryList = sourceDirectoryList;
    }

    @Override
    public void handleClass(IClass clazz, F4FApp app, F4FActions actions) {
        Annotation webServiceAnnotation = JAXWSUtils.getAnnotation(app, clazz, "Ljavax/jws/WebService");
        if (webServiceAnnotation == null) {
            this.logger.debug((Object)("JAX-WS: skipping class: " + clazz.getName().toString() + " as class in not annotated with @WebService"));
            return;
        }
        this.logger.info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/jws/WebService"}));
        ArrayList<IMethod> webMethods = this.findWebMethods(clazz, app, webServiceAnnotation);
        for (IMethod webMethod : webMethods) {
            this.createSyntheticMethods(app, actions, webMethod);
            this.reportAsWSDLService(app, webMethod);
        }
    }

    private void reportAsWSDLService(F4FApp app, IMethod method) {
        this.logger.debug((Object)("JAX-WS: start reporting WSDL service for method: " + method.getSignature()));
        IClass clazz = method.getDeclaringClass();
        String targetNamespace = JAXWSToWSDLUtil.getTargetNamespace(app, clazz);
        String serviceName = JAXWSToWSDLUtil.getServiceName(app, clazz);
        String operationName = JAXWSToWSDLUtil.getOperationName(app, method);
        ArrayList<String> wsdlParamList = JAXWSToWSDLUtil.convertJavaParamToWSDL(app, method, targetNamespace);
        WSDLReportingUtil.reportService((String)targetNamespace, (String)serviceName, (String)operationName, wsdlParamList);
        this.logger.debug((Object)("JAX-WS: end reporting WSDL service for method: " + method.getSignature()));
    }

    private ArrayList<IMethod> findWebMethods(IClass clazz, F4FApp app, Annotation webServiceAnnotation) {
        String seiName;
        IClass seiClazz;
        ArrayList<IMethod> webMethods = new ArrayList();
        Map namedArgs = webServiceAnnotation.getNamedArguments();
        if (namedArgs != null && namedArgs.containsKey("endpointInterface") && (seiClazz = app.getIClass(seiName = ((AnnotationsReader.ElementValue)namedArgs.get("endpointInterface")).toString())) != null) {
            webMethods = this.findExplicitSEIMethods(clazz, app, seiClazz);
            return webMethods;
        }
        webMethods = this.findImplicitSEIMethods(clazz, app);
        return webMethods;
    }

    private ArrayList<IMethod> findExplicitSEIMethods(IClass clazz, F4FApp app, IClass endPointInterfaceClazz) {
        ArrayList<IMethod> webMethods = new ArrayList<IMethod>();
        this.logger.debug((Object)("JAX-WS: found explicit service endpoint interface " + clazz.getName().toString()));
        ArrayList<IMethod> interfaceWebMethods = JAXWSUtils.findCandidateWebMethods(endPointInterfaceClazz, app);
        block0: for (IMethod interfaceWebMethod : interfaceWebMethods) {
            for (IMethod clazzMethod : clazz.getDeclaredMethods()) {
                if (!JAXWSUtils.hasSameSignature(interfaceWebMethod, clazzMethod).booleanValue()) continue;
                this.logger.info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{clazzMethod.getSignature()}));
                webMethods.add(clazzMethod);
                continue block0;
            }
        }
        return webMethods;
    }

    private ArrayList<IMethod> findImplicitSEIMethods(IClass clazz, F4FApp app) {
        this.logger.debug((Object)("JAX-WS: found implicit service endpoint interface " + clazz.getName().toString()));
        ArrayList<IMethod> webMethods = JAXWSUtils.findCandidateWebMethods(clazz, app);
        return webMethods;
    }

    private void createSyntheticMethods(F4FApp app, F4FActions actions, IMethod webMethod) {
        if (webMethod == null) {
            return;
        }
        String methodVdbSig = "AppScan.Synthetic.JAXWS." + VDBJavaUtil.jvmToVDBSignature((String)webMethod.getSignature());
        this.logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{methodVdbSig}));
        HighLevelSyntheticMethod synthMethod = HighLevelSyntheticMethod.make((String)methodVdbSig);
        this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{webMethod.getDeclaringClass().getName().toString()}));
        Local objInstance = synthMethod.newLocal(webMethod.getDeclaringClass());
        Collection[] methodParamAnnotations = app.getMethodParametersAnnotations(webMethod);
        Param[] methodParams = new Param[webMethod.getNumberOfParameters()];
        methodParams[0] = objInstance;
        HashMap<Local, String> holderObjList = new HashMap<Local, String>();
        for (int i = 1; i < webMethod.getNumberOfParameters(); ++i) {
            int actualParamIndex = i - 1;
            Collection paramAnnotationColl = methodParamAnnotations[actualParamIndex];
            JAXWSUtils.WebParamDirection paramDirection = JAXWSUtils.getWebPramDirection(paramAnnotationColl);
            if (paramDirection == JAXWSUtils.WebParamDirection.IN || paramDirection == JAXWSUtils.WebParamDirection.NONE) {
                this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, i}));
                methodParams[i] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
                continue;
            }
            this.logger.debug((Object)("JAX-WS: found out/in-out parameter in method " + webMethod.getSignature()));
            TypeReference paramType = webMethod.getParameterType(i);
            IClass paramTypeClazz = webMethod.getClassHierarchy().lookupClass(paramType);
            this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{paramTypeClazz.getName().toString()}));
            Local holderParamObj = synthMethod.newLocal(paramTypeClazz);
            if (paramDirection == JAXWSUtils.WebParamDirection.IN_OUT) {
                IField writeTo = JAXWSUtils.getFieldByName(app, "javax.xml.ws.Holder", "value");
                this.logger.info((Object)Messages.getString((String)"framework.taint.found", (Object[])new Object[]{""}));
                this.logger.info((Object)Messages.getString((String)"framework.generate.write", (Object[])new Object[]{paramTypeClazz.getName().toString() + "." + writeTo.getName().toString()}));
                synthMethod.addInstanceVariableWrite(holderParamObj, writeTo, (Param)Taint.taint(), null);
            }
            methodParams[i] = holderParamObj;
            String genericType = JAXWSUtils.getHolderType(webMethod, i);
            if (genericType == null) {
                genericType = "java.lang.Object";
            }
            holderObjList.put(holderParamObj, genericType);
        }
        FilePositionInfo methodPositionInfo = JavaUtils.getMethodPosition((IMethod)webMethod, this.sourceDirectoryList);
        this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{webMethod.getSignature()}));
        Local returnValueObj = synthMethod.addCall(webMethod, methodPositionInfo, methodParams);
        if (returnValueObj != null || holderObjList.size() > 0) {
            this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{"java.io.PrintWriter"}));
            Local printWriterObj = synthMethod.newLocal("java.io.PrintWriter");
            if (returnValueObj != null) {
                IClass genClass;
                String genType;
                this.logger.debug((Object)("JAX-WS: serializing return value of method " + webMethod.getSignature()));
                TypeReference typeReference = webMethod.getReturnType();
                IClass returnObjClazz = webMethod.getClassHierarchy().lookupClass(typeReference);
                if (JAXWSUtils.findInterface(returnObjClazz, "Ljava/util/Collection") != null && (genType = JAXWSUtils.findGenericType(webMethod)) != null && (genClass = app.getIClass(genType)) != null && genClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                    Local obj;
                    this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Collection.iterator():java.util.Iterator"}));
                    Local iteratorObj = synthMethod.addCall("java.util.Collection.iterator():java.util.Iterator", null, new Param[]{returnValueObj});
                    this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Iterator.next():java.lang.Object"}));
                    returnValueObj = obj = synthMethod.addCallWithReturnType("java.util.Iterator.next():java.lang.Object", null, genType, new Param[]{iteratorObj});
                    returnObjClazz = genClass;
                }
                JAXWSUtils.serializeObject(app, synthMethod, returnObjClazz, returnValueObj, printWriterObj, new HashSet<IClass>());
            }
            if (holderObjList.size() > 0) {
                this.logger.debug((Object)("JAX-WS: serializing output parameter of method " + webMethod.getSignature()));
                IField readFrom = JAXWSUtils.getFieldByName(app, "javax.xml.ws.Holder", "value");
                for (Map.Entry holderObj : holderObjList.entrySet()) {
                    Local holderParam = (Local)holderObj.getKey();
                    String genericTypeName = (String)holderObj.getValue();
                    this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{genericTypeName}));
                    Local outParamObj = synthMethod.newLocal(genericTypeName);
                    IClass outParamClazz = app.getIClass(genericTypeName);
                    this.logger.info((Object)Messages.getString((String)"framework.generate.write", (Object[])new Object[]{outParamObj.getName()}));
                    synthMethod.addInstanceVariableRead((Param)holderParam, readFrom, (Param)outParamObj, null);
                    JAXWSUtils.serializeObject(app, synthMethod, outParamClazz, outParamObj, printWriterObj, new HashSet<IClass>());
                }
            }
        }
        this.logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{synthMethod.getVdbSignature()}));
        actions.addHighLevelSyntheticMethod(synthMethod, true);
    }
}

