/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.processing;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class F4FHandlerJarUtil {
    private static final Logger logger = TaintLogger.i().getLogger();
    private static final boolean VERBOSE = false;

    public static IFrameworkInfo runAllHandlerJars(String jarDir, IClassHierarchy cha, FrameworksInput input) {
        F4FActions actions = new F4FActions();
        F4FApp app = new F4FApp(cha);
        for (F4FHandler handler : F4FHandlerJarUtil.getHandlers(jarDir)) {
            try {
                handler.setFrameworksInput(input);
                if (!handler.isApplicable()) continue;
                handler.handleApp(app, actions);
            }
            catch (Exception e) {
                logger.warn((Object)("did not succesfully run handler of type " + handler.getClass()), (Throwable)e);
            }
        }
        return F4FActionProcessor.generateFrameworkInfo(app, actions);
    }

    public static List<F4FHandler> getHandlers(String jarDir) {
        Collection<String> jarFileNames = F4FHandlerJarUtil.getJarFileNames(jarDir);
        Collection<String> frameworkHandlerNames = F4FHandlerJarUtil.getFrameworkHandlerNames(jarFileNames);
        ClassLoader loader = F4FHandlerJarUtil.loadJarsIntoClassLoader(jarFileNames);
        return F4FHandlerJarUtil.instantiateHandlers(loader, frameworkHandlerNames);
    }

    private static List<F4FHandler> instantiateHandlers(ClassLoader loader, Collection<String> frameworkHandlerNames) {
        ArrayList<F4FHandler> result = new ArrayList<F4FHandler>();
        for (String frameworkHandlerClass : frameworkHandlerNames) {
            Class<?> klass = null;
            try {
                klass = loader.loadClass(frameworkHandlerClass);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("could not load class " + frameworkHandlerClass));
                continue;
            }
            F4FHandler handler = null;
            try {
                handler = (F4FHandler)klass.newInstance();
            }
            catch (InstantiationException e) {
                logger.warn((Object)("could not instantiate class " + frameworkHandlerClass), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("could not instantiate class " + frameworkHandlerClass), (Throwable)e);
                continue;
            }
            result.add(handler);
        }
        return result;
    }

    private static ClassLoader loadJarsIntoClassLoader(Collection<String> jarFileNames) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String name : jarFileNames) {
            try {
                urls.add(new File(name).toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.warn((Object)("IO error trying to read handler jar " + name), (Throwable)e);
            }
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlArray, F4FHandlerJarUtil.class.getClassLoader());
    }

    private static Collection<String> getFrameworkHandlerNames(Collection<String> jarFileNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : jarFileNames) {
            String handlerName = F4FHandlerJarUtil.getFrameworkHandlerClass(new File(name));
            if (handlerName == null) continue;
            result.add(handlerName);
        }
        return result;
    }

    private static Collection<String> getJarFileNames(String jarDir) {
        ArrayList<String> result = new ArrayList<String>();
        File d = new File(jarDir);
        if (!d.isDirectory()) {
            logger.warn((Object)(jarDir + " is not a directory"));
        } else {
            for (File f : d.listFiles()) {
                if (!f.getPath().endsWith(".jar")) continue;
                result.add(f.getAbsolutePath());
            }
        }
        return result;
    }

    private static String getFrameworkHandlerClass(File jarFile) {
        try {
            JarInputStream s = new JarInputStream(new FileInputStream(jarFile));
            Manifest m = s.getManifest();
            Attributes attr = m.getMainAttributes();
            if (attr == null) {
                logger.warn((Object)("unable to read manifest from handler jar " + jarFile.getAbsolutePath()));
                return null;
            }
            String result = attr.getValue("Framework-Handler");
            if (result == null) {
                logger.debug((Object)("manifest missing Framework-Handler attribute for handler jar " + jarFile.getAbsolutePath()));
            }
            return result;
        }
        catch (IOException e) {
            logger.warn((Object)("IO error trying to read handler jar " + jarFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }
}

