/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.internal.BeanSerializer;
import org.apache.commons.json.internal.Parser;
import org.apache.commons.json.internal.Serializer;
import org.apache.commons.json.internal.SerializerVerbose;

public class JSONArray
extends ArrayList
implements JSONArtifact {
    private static final long serialVersionUID = 9076798781015779954L;

    public JSONArray() {
    }

    public JSONArray(int n) {
        super(n);
    }

    public JSONArray(Collection collection) throws JSONException {
        super(collection.size());
        Iterator iterator = collection.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    public JSONArray(Object[] objectArray) throws JSONException {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.add(objectArray[i]);
            }
        }
    }

    public JSONArray(Object[] objectArray, boolean bl) throws JSONException {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.add(objectArray[i]);
            }
        }
    }

    public JSONArray(Collection collection, boolean bl) throws JSONException {
        super(collection.size());
        Iterator iterator = collection.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.add(iterator.next(), true);
            }
        }
    }

    public JSONArray(String string) throws JSONException {
        StringReader stringReader = new StringReader(string);
        new Parser(stringReader).parse(this);
    }

    public JSONArray(String string, boolean bl) throws JSONException {
        StringReader stringReader = new StringReader(string);
        new Parser(stringReader, bl).parse(this);
    }

    public JSONArray(Reader reader) throws JSONException {
        new Parser(reader).parse(this);
    }

    public JSONArray(Reader reader, boolean bl) throws JSONException {
        new Parser(reader, bl).parse(this);
    }

    public JSONArray(InputStream inputStream) throws JSONException {
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        } else {
            throw new JSONException("Inputstream cannot be null");
        }
        new Parser(inputStreamReader).parse(true, this);
    }

    public JSONArray(InputStream inputStream, boolean bl) throws JSONException {
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        } else {
            throw new JSONException("InputStream cannot be null");
        }
        new Parser(inputStreamReader, bl).parse(true, this);
    }

    public Object getIndex(int n) throws JSONException {
        try {
            return super.get(n);
        }
        catch (Exception exception) {
            JSONException jSONException = new JSONException("Error occurred trying to access element at: " + n);
            jSONException.initCause(exception);
            throw jSONException;
        }
    }

    public void add(int n, Object object) {
        if (n > this.size() - 1) {
            this.expandArray(n);
        }
        if (!JSONObject.isValidObject(object)) {
            try {
                object = BeanSerializer.toJson(object, true);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        super.add(n, object);
    }

    public boolean add(Object object, boolean bl) {
        if (!JSONObject.isValidObject(object)) {
            try {
                object = BeanSerializer.toJson(object, bl);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        return super.add(object);
    }

    public boolean add(Object object) {
        return this.add(object, true);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!JSONObject.isValidObject(object)) {
                try {
                    object = BeanSerializer.toJson(object, true);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
                }
            }
            super.add(object);
        }
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        if (n > this.size() - 1) {
            this.expandArray(n);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!JSONObject.isValidObject(object)) {
                try {
                    object = BeanSerializer.toJson(object, true);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
                }
            }
            super.add(n, object);
            ++n;
        }
        return true;
    }

    public Object set(int n, Object object) {
        if (n > this.size() - 1) {
            this.expandArray(n);
        }
        if (!JSONObject.isValidObject(object)) {
            try {
                object = BeanSerializer.toJson(object, true);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        return super.set(n, object);
    }

    private void expandArray(int n) {
        int n2 = this.size();
        if ((n -= n2) > 0) {
            for (int i = 0; i < n; ++i) {
                super.add(null);
            }
        }
    }

    public JSONArray put(int n, Object object) throws JSONException {
        if (!JSONObject.isValidObject(object)) {
            try {
                object = BeanSerializer.toJson(object, true);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        try {
            super.add(n, object);
        }
        catch (Exception exception) {
            JSONException jSONException = new JSONException("Exception occurred while placing element.");
            jSONException.initCause(exception);
            throw jSONException;
        }
        return this;
    }

    public JSONArray put(Object object) throws JSONException {
        return this.put(object, true);
    }

    public JSONArray put(Object object, boolean bl) throws JSONException {
        if (!JSONObject.isValidObject(object)) {
            try {
                object = BeanSerializer.toJson(object, bl);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Object of type: [" + object.getClass().getName() + "] could not be converted to a JSON representation.");
            }
        }
        try {
            super.add(object);
        }
        catch (Exception exception) {
            JSONException jSONException = new JSONException("Exception occurred while placing element.");
            jSONException.initCause(exception);
            throw jSONException;
        }
        return this;
    }

    public JSONArray put(int n, Map map) throws JSONException {
        return this.put(n, map, true);
    }

    public JSONArray put(int n, Map map, boolean bl) throws JSONException {
        if (map == null) {
            this.add((Object)null);
        } else if (JSONObject.class.isAssignableFrom(map.getClass())) {
            this.add(n, map);
        } else {
            this.add(n, new JSONObject(map, bl));
        }
        return this;
    }

    public JSONArray put(Map map) throws JSONException {
        return this.put(map, true);
    }

    public JSONArray put(Map map, boolean bl) throws JSONException {
        if (map == null) {
            this.add((Object)null);
        } else if (JSONObject.class.isAssignableFrom(map.getClass())) {
            this.add(map);
        } else {
            this.add(new JSONObject(map, bl));
        }
        return this;
    }

    public JSONArray put(int n, Collection collection) throws JSONException {
        return this.put(n, collection, true);
    }

    public JSONArray put(int n, Collection collection, boolean bl) throws JSONException {
        if (collection == null) {
            this.add((Object)null);
        } else if (JSONArray.class.isAssignableFrom(collection.getClass())) {
            this.add(n, collection);
        } else {
            this.add(n, new JSONArray(collection, bl));
        }
        return this;
    }

    public JSONArray put(Collection collection) throws JSONException {
        return this.put(collection, true);
    }

    public JSONArray put(Collection collection, boolean bl) throws JSONException {
        if (collection == null) {
            this.add((Object)null);
        } else if (JSONArray.class.isAssignableFrom(collection.getClass())) {
            this.add(collection);
        } else {
            this.add(new JSONArray(collection, bl));
        }
        return this;
    }

    public JSONArray put(long l) {
        this.add(new Long(l));
        return this;
    }

    public JSONArray put(int n, long l) {
        this.add(n, new Long(l));
        return this;
    }

    public JSONArray put(int n) {
        this.add(new Integer(n));
        return this;
    }

    public JSONArray put(int n, int n2) {
        this.add(n, new Integer(n2));
        return this;
    }

    public JSONArray put(short s) {
        this.add(new Short(s));
        return this;
    }

    public JSONArray put(int n, short s) {
        this.add(n, new Short(s));
        return this;
    }

    public JSONArray put(double d) {
        this.add(new Double(d));
        return this;
    }

    public JSONArray put(int n, double d) {
        this.add(n, new Double(d));
        return this;
    }

    public JSONArray put(boolean bl) {
        this.add(new Boolean(bl));
        return this;
    }

    public JSONArray put(int n, boolean bl) {
        this.add(n, new Boolean(bl));
        return this;
    }

    public boolean getBoolean(int n) throws JSONException {
        block8: {
            try {
                Object e = this.get(n);
                if (e != null) {
                    if (Boolean.class.isAssignableFrom(e.getClass())) {
                        return (Boolean)e;
                    }
                    if (Number.class.isAssignableFrom(e.getClass())) {
                        throw new JSONException("Value at index: [" + n + "] was not a boolean or string value of 'true' or 'false'.");
                    }
                    if (String.class.isAssignableFrom(e.getClass())) {
                        String string = (String)e;
                        if (string.equals("true")) {
                            return true;
                        }
                        if (string.equals("false")) {
                            return false;
                        }
                        throw new JSONException("Value at index: [" + n + "] was not a boolean or string value of 'true' or 'false'.");
                    }
                    break block8;
                }
                throw new JSONException("Value at index: [" + n + "] was null");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
                jSONException.initCause(indexOutOfBoundsException);
                throw jSONException;
            }
        }
        return false;
    }

    public double getDouble(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                if (Number.class.isAssignableFrom(e.getClass())) {
                    return ((Number)e).doubleValue();
                }
                throw new JSONException("Value at index: [" + n + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + n + "] was null");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public long getLong(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                if (Number.class.isAssignableFrom(e.getClass())) {
                    return ((Number)e).longValue();
                }
                throw new JSONException("Value at index: [" + n + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + n + "] was null");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public int getInt(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                if (Number.class.isAssignableFrom(e.getClass())) {
                    return ((Number)e).intValue();
                }
                throw new JSONException("Value at index: [" + n + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + n + "] was null");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public short getShort(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                if (Number.class.isAssignableFrom(e.getClass())) {
                    return ((Number)e).shortValue();
                }
                throw new JSONException("Value at index: [" + n + "] was not a number.");
            }
            throw new JSONException("Value at index: [" + n + "] was null");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public String getString(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                return e.toString();
            }
            throw new JSONException("The value at index: [" + n + "] was null.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public JSONObject getJSONObject(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                if (JSONObject.class.isAssignableFrom(e.getClass())) {
                    return (JSONObject)e;
                }
                throw new JSONException("The value for index: [" + n + "] was not a JSONObject");
            }
            throw new JSONException("The value for index: [" + n + "] was null.  Object required.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public JSONArray getJSONArray(int n) throws JSONException {
        try {
            Object e = this.get(n);
            if (e != null) {
                if (JSONArray.class.isAssignableFrom(e.getClass())) {
                    return (JSONArray)e;
                }
                throw new JSONException("The value index key: [" + n + "] was not a JSONObject");
            }
            throw new JSONException("The value for index: [" + n + "] was null.  Object required.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            JSONException jSONException = new JSONException("The specified index was outside of the array boundries");
            jSONException.initCause(indexOutOfBoundsException);
            throw jSONException;
        }
    }

    public boolean isNull(int n) {
        try {
            Object e = this.get(n);
            return e == null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return true;
        }
    }

    public int length() {
        return this.size();
    }

    public OutputStream write(OutputStream outputStream) throws JSONException {
        this.write(outputStream, false);
        return outputStream;
    }

    public OutputStream write(OutputStream outputStream, boolean bl) throws JSONException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JSONException jSONException = new JSONException(unsupportedEncodingException.toString());
            jSONException.initCause(unsupportedEncodingException);
            throw jSONException;
        }
        this.write((Writer)bufferedWriter, bl);
        return outputStream;
    }

    public OutputStream write(OutputStream outputStream, int n) throws JSONException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JSONException jSONException = new JSONException(unsupportedEncodingException.toString());
            jSONException.initCause(unsupportedEncodingException);
            throw jSONException;
        }
        this.write((Writer)bufferedWriter, n);
        return outputStream;
    }

    public Writer write(Writer writer) throws JSONException {
        this.write(writer, false);
        return writer;
    }

    public Writer write(Writer writer, boolean bl) throws JSONException {
        Class<?> clazz = writer.getClass();
        boolean bl2 = false;
        if (!(StringWriter.class.isAssignableFrom(clazz) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
            bl2 = true;
        }
        Serializer serializer = bl ? new SerializerVerbose(writer) : new Serializer(writer);
        try {
            serializer.writeArray(this);
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        if (bl2) {
            try {
                writer.flush();
            }
            catch (Exception exception) {
                JSONException jSONException = new JSONException("Error during buffer flush");
                jSONException.initCause(exception);
                throw jSONException;
            }
        }
        return writer;
    }

    public Writer write(Writer writer, int n) throws JSONException {
        if (n < 1) {
            n = 0;
        } else if (n > 8) {
            n = 9;
        }
        Class<?> clazz = writer.getClass();
        if (!(StringWriter.class.isAssignableFrom(clazz) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
        }
        Serializer serializer = n > 0 ? new SerializerVerbose(writer, n) : new Serializer(writer);
        try {
            serializer.writeArray(this);
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return writer;
    }

    public String write(boolean bl) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        Serializer serializer = bl ? new SerializerVerbose(stringWriter) : new Serializer(stringWriter);
        try {
            serializer.writeArray(this).flush();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return stringWriter.toString();
    }

    public String write(int n) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        if (n < 1) {
            n = 0;
        } else if (n > 8) {
            n = 9;
        }
        Serializer serializer = n > 0 ? new SerializerVerbose(stringWriter, n) : new Serializer(stringWriter);
        try {
            serializer.writeArray(this).flush();
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
        return stringWriter.toString();
    }

    public String write() throws JSONException {
        return this.write(false);
    }

    public String toString() {
        String string = null;
        try {
            string = this.write(false);
        }
        catch (JSONException jSONException) {
            string = "JSON Generation Error: [" + jSONException.toString() + "]";
        }
        return string;
    }

    public String toString(int n) throws JSONException {
        return this.write(n);
    }

    public String join(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Object e;
            if (i > 0) {
                stringBuffer.append(string);
            }
            if ((e = this.get(i)) == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    public Object opt(int n) {
        try {
            return this.get(n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Object opt(int n, Object object) {
        try {
            return this.get(n);
        }
        catch (Throwable throwable) {
            return object;
        }
    }

    public boolean optBoolean(int n) {
        try {
            return this.getBoolean(n);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean optBoolean(int n, boolean bl) {
        try {
            return this.getBoolean(n);
        }
        catch (Throwable throwable) {
            return bl;
        }
    }

    public int optInt(int n) {
        try {
            return this.getInt(n);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public int optInt(int n, int n2) {
        try {
            return this.getInt(n);
        }
        catch (Throwable throwable) {
            return n2;
        }
    }

    public long optLong(int n) {
        try {
            return this.getLong(n);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public long optLong(int n, long l) {
        try {
            return this.getLong(n);
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    public short optShort(int n) {
        try {
            return this.getShort(n);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public short optShort(int n, short s) {
        try {
            return this.getShort(n);
        }
        catch (Throwable throwable) {
            return s;
        }
    }

    public double optDouble(int n) {
        try {
            return this.getDouble(n);
        }
        catch (Throwable throwable) {
            return Double.NaN;
        }
    }

    public double optDouble(int n, double d) {
        try {
            return this.getDouble(n);
        }
        catch (Throwable throwable) {
            return Double.NaN;
        }
    }

    public String optString(int n) {
        try {
            return this.getString(n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String optString(int n, String string) {
        try {
            return this.getString(n);
        }
        catch (Throwable throwable) {
            return string;
        }
    }
}

