/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json.internal;

import java.io.Serializable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class BeanSerializer {
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$util$List;

    public static JSONArtifact toJson(Object object, boolean bl) throws IllegalArgumentException, JSONException {
        JSONArtifact jSONArtifact = null;
        if (object != null) {
            Class<?> clazz;
            if (String.class == (clazz = object.getClass())) {
                throw new IllegalArgumentException("Class was String type, not a Javabean.");
            }
            if (Boolean.class == clazz) {
                throw new IllegalArgumentException("Class was Boolean type, not a Javabean.");
            }
            if (Number.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class was Number type, not a Javabean.");
            }
            jSONArtifact = JSONObject.class.isAssignableFrom(clazz) ? (JSONObject)object : (JSONArray.class.isAssignableFrom(clazz) ? (JSONArray)object : (Map.class.isAssignableFrom(clazz) ? new JSONObject((Map)object) : (Collection.class.isAssignableFrom(clazz) ? new JSONArray((Collection)object) : (clazz.isArray() ? new JSONArray((Object[])object) : BeanSerializer.introspectBean(object, bl, new ArrayList())))));
        }
        return jSONArtifact;
    }

    private static JSONArtifact introspectBean(Object object, boolean bl, ArrayList arrayList) throws JSONException {
        Object object2;
        JSONObject jSONObject = null;
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = arrayList.get(i);
            if (object2 == null || object != object2) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            arrayList.add(object);
            jSONObject = new JSONObject();
            Class<?> clazz = object.getClass();
            jSONObject.put("_type", (Object)"JavaClass");
            jSONObject.put("_classname", (Object)clazz.getName());
            object2 = null;
            object2 = bl ? clazz.getMethods() : clazz.getDeclaredMethods();
            if (object2 != null && ((E)object2).length > 0) {
                for (int i = 0; i < ((E)object2).length; ++i) {
                    Object e = object2[i];
                    String string = ((Method)e).getName();
                    Class<?>[] classArray = ((Method)e).getParameterTypes();
                    if (!string.startsWith("get") || string.length() <= 3 || classArray != null && classArray.length != 0) continue;
                    String string2 = string.substring(3, string.length());
                    string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1, string2.length());
                    try {
                        Class<?> clazz2;
                        Object object3 = ((Method)e).invoke(object, null);
                        if (object3 == null) {
                            jSONObject.put(string2, (Object)null);
                            continue;
                        }
                        if ((class$java$lang$String == null ? BeanSerializer.class$("java.lang.String") : class$java$lang$String) == (clazz2 = object3.getClass())) {
                            jSONObject.put(string2, object3);
                            continue;
                        }
                        if ((class$java$lang$Boolean == null ? BeanSerializer.class$("java.lang.Boolean") : class$java$lang$Boolean) == clazz2) {
                            jSONObject.put(string2, object3);
                            continue;
                        }
                        if ((class$java$lang$Class == null ? BeanSerializer.class$("java.lang.Class") : class$java$lang$Class) == clazz2) {
                            jSONObject.put(string2, (Object)((Class)object3).getName());
                            continue;
                        }
                        if ((class$java$lang$Number == null ? BeanSerializer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz2)) {
                            jSONObject.put(string2, object3);
                            continue;
                        }
                        if ((class$org$apache$commons$json$JSONObject == null ? BeanSerializer.class$("org.apache.commons.json.JSONObject") : class$org$apache$commons$json$JSONObject).isAssignableFrom(clazz2)) {
                            jSONObject.put(string2, object3);
                            continue;
                        }
                        if ((class$org$apache$commons$json$JSONArray == null ? BeanSerializer.class$("org.apache.commons.json.JSONArray") : class$org$apache$commons$json$JSONArray).isAssignableFrom(clazz2)) {
                            jSONObject.put(string2, object3);
                            continue;
                        }
                        if ((class$java$util$Map == null ? BeanSerializer.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(clazz2)) {
                            jSONObject.put(string2, new JSONObject((Map)object3));
                            continue;
                        }
                        if ((class$java$util$Collection == null ? BeanSerializer.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(clazz2)) {
                            jSONObject.put(string2, new JSONArray((Collection)object));
                            continue;
                        }
                        if (object3 == object) continue;
                        jSONObject.put(string2, (Object)BeanSerializer.introspectBean(object3, bl, arrayList));
                        continue;
                    }
                    catch (Exception exception) {
                        jSONObject.put(string2, (Object)null);
                    }
                }
            }
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object fromJson(JSONObject jSONObject) throws NullPointerException, JSONException {
        Object var1_1 = null;
        if (jSONObject == null) {
            throw new NullPointerException("Input JSONObject cannot be null");
        }
        if (jSONObject.get("_classname") == null || !"JavaClass".equals(jSONObject.get("_type"))) throw new JSONException("Provided JSONObject does not contain attributes '_classname' or '_type'");
        try {
            String string = (String)jSONObject.get("_classname");
            Class<?> clazz = Class.forName(string);
            if (clazz == null) throw new JSONException("Could not locate class: [" + string + "]");
            Method[] methodArray = clazz.getMethods();
            var1_1 = clazz.newInstance();
            Iterator iterator = jSONObject.keys();
            if (iterator == null) return var1_1;
            while (iterator.hasNext()) {
                void var9_48;
                void var7_9;
                String string2 = (String)iterator.next();
                if (string2 == null || string2.equals("_classname") || string2.equals("_type")) continue;
                Object var7_10 = null;
                String string3 = "set" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1, string2.length());
                Object object = jSONObject.get(string2);
                if (object != null) {
                    Serializable serializable;
                    Object object2;
                    GenericDeclaration genericDeclaration;
                    GenericDeclaration genericDeclaration2;
                    Class<?> clazz2;
                    if ((class$java$lang$String == null ? BeanSerializer.class$("java.lang.String") : class$java$lang$String) == (clazz2 = object.getClass())) {
                        for (int i = 0; i < methodArray.length; ++i) {
                            Class<?>[] classArray;
                            genericDeclaration2 = methodArray[i];
                            if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != clazz2) continue;
                            GenericDeclaration genericDeclaration3 = genericDeclaration2;
                            break;
                        }
                    } else if ((class$java$lang$Boolean == null ? BeanSerializer.class$("java.lang.Boolean") : class$java$lang$Boolean) == clazz2) {
                        for (int i = 0; i < methodArray.length; ++i) {
                            Class<?>[] classArray;
                            genericDeclaration2 = methodArray[i];
                            if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != clazz2 && Boolean.TYPE != genericDeclaration) continue;
                            GenericDeclaration genericDeclaration4 = genericDeclaration2;
                            break;
                        }
                    } else if ((class$java$lang$Number == null ? BeanSerializer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz2)) {
                        if ((class$java$lang$Double == null ? BeanSerializer.class$("java.lang.Double") : class$java$lang$Double).isAssignableFrom(clazz2)) {
                            void var7_16;
                            int n;
                            for (n = 0; n < methodArray.length; ++n) {
                                Class<?>[] classArray;
                                genericDeclaration2 = methodArray[n];
                                if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Double == null ? BeanSerializer.class$("java.lang.Double") : class$java$lang$Double) && Double.TYPE != genericDeclaration) continue;
                                GenericDeclaration genericDeclaration5 = genericDeclaration2;
                                break;
                            }
                            if (var7_16 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Float == null ? BeanSerializer.class$("java.lang.Float") : class$java$lang$Float) && Float.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration6 = genericDeclaration2;
                                    Float f = new Float(((Number)object).floatValue());
                                    break;
                                }
                            }
                        } else if ((class$java$lang$Float == null ? BeanSerializer.class$("java.lang.Float") : class$java$lang$Float).isAssignableFrom(clazz2)) {
                            void var7_20;
                            int n;
                            for (n = 0; n < methodArray.length; ++n) {
                                Class<?>[] classArray;
                                genericDeclaration2 = methodArray[n];
                                if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Float == null ? BeanSerializer.class$("java.lang.Float") : class$java$lang$Float) && Float.TYPE != genericDeclaration) continue;
                                GenericDeclaration genericDeclaration7 = genericDeclaration2;
                                break;
                            }
                            if (var7_20 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Double == null ? BeanSerializer.class$("java.lang.Double") : class$java$lang$Double) && Double.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration8 = genericDeclaration2;
                                    Double d = new Double(((Number)object).doubleValue());
                                    break;
                                }
                            }
                        } else if ((class$java$lang$Long == null ? BeanSerializer.class$("java.lang.Long") : class$java$lang$Long).isAssignableFrom(clazz2)) {
                            void var7_26;
                            void var7_24;
                            int n;
                            for (n = 0; n < methodArray.length; ++n) {
                                Class<?>[] classArray;
                                genericDeclaration2 = methodArray[n];
                                if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Long == null ? BeanSerializer.class$("java.lang.Long") : class$java$lang$Long) && Long.TYPE != genericDeclaration) continue;
                                GenericDeclaration genericDeclaration9 = genericDeclaration2;
                                break;
                            }
                            if (var7_24 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Integer == null ? BeanSerializer.class$("java.lang.Integer") : class$java$lang$Integer) && Integer.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration10 = genericDeclaration2;
                                    Integer n2 = new Integer(((Number)object).intValue());
                                    break;
                                }
                            }
                            if (var7_26 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    void var9_55;
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Short == null ? BeanSerializer.class$("java.lang.Short") : class$java$lang$Short) && Short.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration11 = genericDeclaration2;
                                    Short s = new Short(((Number)var9_55).shortValue());
                                    break;
                                }
                            }
                        } else if ((class$java$lang$Integer == null ? BeanSerializer.class$("java.lang.Integer") : class$java$lang$Integer).isAssignableFrom(clazz2)) {
                            void var7_32;
                            void var7_30;
                            int n;
                            for (n = 0; n < methodArray.length; ++n) {
                                Class<?>[] classArray;
                                genericDeclaration2 = methodArray[n];
                                if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Integer == null ? BeanSerializer.class$("java.lang.Integer") : class$java$lang$Integer) && Integer.TYPE != genericDeclaration) continue;
                                GenericDeclaration genericDeclaration12 = genericDeclaration2;
                                break;
                            }
                            if (var7_30 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Long == null ? BeanSerializer.class$("java.lang.Long") : class$java$lang$Long) && Long.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration13 = genericDeclaration2;
                                    Long l = new Long(((Number)object).longValue());
                                    break;
                                }
                            }
                            if (var7_32 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    void var9_59;
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Short == null ? BeanSerializer.class$("java.lang.Short") : class$java$lang$Short) && Short.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration14 = genericDeclaration2;
                                    Short s = new Short(((Number)var9_59).shortValue());
                                    break;
                                }
                            }
                        } else if ((class$java$lang$Short == null ? BeanSerializer.class$("java.lang.Short") : class$java$lang$Short).isAssignableFrom(clazz2)) {
                            void var7_38;
                            void var7_36;
                            int n;
                            for (n = 0; n < methodArray.length; ++n) {
                                Class<?>[] classArray;
                                genericDeclaration2 = methodArray[n];
                                if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Short == null ? BeanSerializer.class$("java.lang.Short") : class$java$lang$Short) && Short.TYPE != genericDeclaration) continue;
                                GenericDeclaration genericDeclaration15 = genericDeclaration2;
                                break;
                            }
                            if (var7_36 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Integer == null ? BeanSerializer.class$("java.lang.Integer") : class$java$lang$Integer) && Integer.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration16 = genericDeclaration2;
                                    Integer n3 = new Integer(((Number)object).intValue());
                                    break;
                                }
                            }
                            if (var7_38 == null) {
                                for (n = 0; n < methodArray.length; ++n) {
                                    void var9_63;
                                    Class<?>[] classArray;
                                    genericDeclaration2 = methodArray[n];
                                    if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || (genericDeclaration = classArray[0]) != (class$java$lang$Long == null ? BeanSerializer.class$("java.lang.Long") : class$java$lang$Long) && Long.TYPE != genericDeclaration) continue;
                                    GenericDeclaration genericDeclaration17 = genericDeclaration2;
                                    Long l = new Long(((Number)var9_63).longValue());
                                    break;
                                }
                            }
                        }
                    } else if ((class$org$apache$commons$json$JSONArray == null ? BeanSerializer.class$("org.apache.commons.json.JSONArray") : class$org$apache$commons$json$JSONArray).isAssignableFrom(clazz2)) {
                        for (int i = 0; i < methodArray.length; ++i) {
                            Class<?>[] classArray;
                            genericDeclaration2 = methodArray[i];
                            if (!((Method)genericDeclaration2).getName().equals(string3) || (classArray = ((Method)genericDeclaration2).getParameterTypes()) == null || classArray.length != 1 || !(class$java$util$List == null ? BeanSerializer.class$("java.util.List") : class$java$util$List).isAssignableFrom((Class<?>)(genericDeclaration = classArray[0]))) continue;
                            GenericDeclaration genericDeclaration18 = genericDeclaration2;
                            if (genericDeclaration == (class$org$apache$commons$json$JSONArray == null ? BeanSerializer.class$("org.apache.commons.json.JSONArray") : class$org$apache$commons$json$JSONArray)) break;
                            object2 = (List)((Class)genericDeclaration).newInstance();
                            serializable = (JSONArray)object;
                            for (int j = 0; j < ((JSONArray)serializable).length(); ++j) {
                                Object e = ((ArrayList)serializable).get(j);
                                if (e != null) {
                                    Class<?> clazz3;
                                    if ((class$java$lang$Number == null ? BeanSerializer.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz3 = e.getClass()) || (class$java$lang$Boolean == null ? BeanSerializer.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(clazz3) || (class$java$lang$String == null ? BeanSerializer.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(clazz3)) {
                                        object2.add(e);
                                        continue;
                                    }
                                    if ((class$org$apache$commons$json$JSONObject == null ? BeanSerializer.class$("org.apache.commons.json.JSONObject") : class$org$apache$commons$json$JSONObject).isAssignableFrom(clazz3)) {
                                        object2.add(BeanSerializer.fromJson((JSONObject)e));
                                        continue;
                                    }
                                    if (!(class$org$apache$commons$json$JSONObject == null ? BeanSerializer.class$("org.apache.commons.json.JSONObject") : class$org$apache$commons$json$JSONObject).isAssignableFrom(clazz3)) continue;
                                }
                                object2.add(null);
                            }
                            Object object3 = object2;
                            break;
                        }
                    } else {
                        if (!(class$org$apache$commons$json$JSONObject == null ? BeanSerializer.class$("org.apache.commons.json.JSONObject") : class$org$apache$commons$json$JSONObject).isAssignableFrom(clazz2)) throw new JSONException("Unknown type: [" + clazz2.getName() + "]");
                        JSONObject jSONObject2 = (JSONObject)object;
                        genericDeclaration2 = object.getClass();
                        if (jSONObject2.get("_classname") != null && "JavaClass".equals(jSONObject2.get("_type"))) {
                            Object object4 = BeanSerializer.fromJson(jSONObject2);
                            genericDeclaration2 = object4.getClass();
                        }
                        for (int i = 0; i < methodArray.length; ++i) {
                            genericDeclaration = methodArray[i];
                            if (!((Method)genericDeclaration).getName().equals(string3) || (object2 = ((Method)genericDeclaration).getParameterTypes()) == null || ((Class<?>[])object2).length != 1 || !((Class)(serializable = object2[0])).isAssignableFrom((Class<?>)genericDeclaration2)) continue;
                            GenericDeclaration genericDeclaration19 = genericDeclaration;
                            break;
                        }
                    }
                } else {
                    try {
                        Method method = clazz.getMethod(string3, null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (var7_9 == null) continue;
                var7_9.invoke(var1_1, var9_48);
            }
            return var1_1;
        }
        catch (Exception exception) {
            if (exception instanceof JSONException) {
                throw (JSONException)exception;
            }
            JSONException jSONException = new JSONException("Error in converting JSON to Java Class");
            jSONException.initCause(exception);
            throw jSONException;
        }
    }
}

