/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json.internal;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.json.internal.Token;

public class Tokenizer {
    private Reader reader;
    private int lineNo;
    private int colNo;
    private int lastChar;
    private boolean strict = false;

    public Tokenizer(Reader reader) throws IOException {
        Class<?> clazz = reader.getClass();
        if (!(StringReader.class.isAssignableFrom(clazz) || CharArrayReader.class.isAssignableFrom(clazz) || PushbackReader.class.isAssignableFrom(clazz) || BufferedReader.class.isAssignableFrom(clazz))) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.lineNo = 0;
        this.colNo = 0;
        this.lastChar = 10;
        this.readChar();
    }

    public Tokenizer(Reader reader, boolean bl) throws IOException {
        Class<?> clazz = reader.getClass();
        if (!(StringReader.class.isAssignableFrom(clazz) || CharArrayReader.class.isAssignableFrom(clazz) || PushbackReader.class.isAssignableFrom(clazz) || BufferedReader.class.isAssignableFrom(clazz))) {
            reader = new BufferedReader(reader);
        }
        this.reader = reader;
        this.lineNo = 0;
        this.colNo = 0;
        this.lastChar = 10;
        this.strict = bl;
        this.readChar();
    }

    public Token next() throws IOException {
        while (this.isWhitespace((char)this.lastChar)) {
            this.readChar();
        }
        switch (this.lastChar) {
            case -1: {
                this.readChar();
                return Token.TokenEOF;
            }
            case 123: {
                this.readChar();
                return Token.TokenBraceL;
            }
            case 125: {
                this.readChar();
                return Token.TokenBraceR;
            }
            case 91: {
                this.readChar();
                return Token.TokenBrackL;
            }
            case 93: {
                this.readChar();
                return Token.TokenBrackR;
            }
            case 58: {
                this.readChar();
                return Token.TokenColon;
            }
            case 44: {
                this.readChar();
                return Token.TokenComma;
            }
            case 34: 
            case 39: {
                String string = this.readString();
                return new Token(string);
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Number number = this.readNumber();
                return new Token(number);
            }
            case 102: 
            case 110: 
            case 116: {
                String string = this.readIdentifier();
                if (string.equals("null")) {
                    return Token.TokenNull;
                }
                if (string.equals("true")) {
                    return Token.TokenTrue;
                }
                if (string.equals("false")) {
                    return Token.TokenFalse;
                }
                if (!this.strict) {
                    return new Token(string);
                }
                throw new IOException("Unexpected unquoted string literal: [" + string + "].  Unquoted strings are not allowed in strict mode");
            }
            case 47: {
                if (!this.strict) {
                    this.readComment();
                    return this.next();
                }
                throw new IOException("Unexpected character / encountered " + this.onLineCol() + ".  Comments are not allowed in strict mode");
            }
        }
        if (!this.strict && this.isValidUnquotedChar((char)this.lastChar)) {
            String string = this.readIdentifier();
            return new Token(string);
        }
        if (this.strict) {
            throw new IOException("Unexpected character '" + (char)this.lastChar + "' " + this.onLineCol() + ".  Unquoted strings are not allowed in strict mode.");
        }
        throw new IOException("Unexpected character '" + (char)this.lastChar + "' " + this.onLineCol());
    }

    private void readComment() throws IOException {
        block7: {
            block6: {
                this.readChar();
                if ((char)this.lastChar != '/') break block6;
                while ((char)this.lastChar != '\n' && this.lastChar != -1) {
                    this.readChar();
                }
                break block7;
            }
            if ((char)this.lastChar != '*') break block7;
            char[] cArray = new char[2];
            this.readChar();
            if (this.lastChar == -1) {
                return;
            }
            cArray[0] = (char)this.lastChar;
            this.readChar();
            if (this.lastChar != -1) {
                cArray[1] = (char)this.lastChar;
            } else {
                return;
            }
            while (cArray[0] != '*' || cArray[1] != '/') {
                this.readChar();
                if (this.lastChar != -1) {
                    cArray[0] = cArray[1];
                    cArray[1] = (char)this.lastChar;
                    continue;
                }
                return;
            }
        }
    }

    private String readString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lastChar;
        int n2 = this.lineNo;
        int n3 = this.colNo;
        this.readChar();
        block16: while (-1 != this.lastChar && n != this.lastChar) {
            int n4;
            StringBuffer stringBuffer2;
            if (this.lastChar != 92) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
                continue;
            }
            this.readChar();
            switch (this.lastChar) {
                case 98: {
                    this.readChar();
                    stringBuffer.append('\b');
                    continue block16;
                }
                case 102: {
                    this.readChar();
                    stringBuffer.append('\f');
                    continue block16;
                }
                case 110: {
                    this.readChar();
                    stringBuffer.append('\n');
                    continue block16;
                }
                case 114: {
                    this.readChar();
                    stringBuffer.append('\r');
                    continue block16;
                }
                case 116: {
                    this.readChar();
                    stringBuffer.append('\t');
                    continue block16;
                }
                case 39: {
                    this.readChar();
                    stringBuffer.append('\'');
                    continue block16;
                }
                case 34: {
                    this.readChar();
                    stringBuffer.append('\"');
                    continue block16;
                }
                case 92: {
                    this.readChar();
                    stringBuffer.append('\\');
                    continue block16;
                }
                case 47: {
                    this.readChar();
                    stringBuffer.append('/');
                    continue block16;
                }
                case 117: 
                case 120: {
                    stringBuffer2 = new StringBuffer();
                    int n5 = 2;
                    if (this.lastChar == 117) {
                        n5 = 4;
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.readChar();
                        if (!this.isHexDigit(this.lastChar)) {
                            throw new IOException("non-hex digit " + this.onLineCol());
                        }
                        stringBuffer2.append((char)this.lastChar);
                    }
                    this.readChar();
                    try {
                        n4 = Integer.parseInt(stringBuffer2.toString(), 16);
                        stringBuffer.append((char)n4);
                        continue block16;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("non-hex digit " + this.onLineCol());
                    }
                }
            }
            if (!this.isOctalDigit(this.lastChar)) {
                throw new IOException("non-hex digit " + this.onLineCol());
            }
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append((char)this.lastChar);
            for (n4 = 0; n4 < 2; ++n4) {
                this.readChar();
                if (!this.isOctalDigit(this.lastChar)) break;
                stringBuffer2.append((char)this.lastChar);
            }
            try {
                n4 = Integer.parseInt(stringBuffer2.toString(), 8);
                stringBuffer.append((char)n4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("non-hex digit " + this.onLineCol());
            }
        }
        if (-1 == this.lastChar) {
            throw new IOException("String not terminated " + this.onLineCol(n2, n3));
        }
        this.readChar();
        return stringBuffer.toString();
    }

    private Number readNumber() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.lineNo;
        int n2 = this.colNo;
        boolean bl = false;
        if (this.lastChar == 45) {
            stringBuffer.append((char)this.lastChar);
            this.readChar();
        }
        if (this.lastChar == 48) {
            stringBuffer.append((char)this.lastChar);
            this.readChar();
            if (this.lastChar == 120 || this.lastChar == 88) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
                bl = true;
            }
        }
        if (bl) {
            while (this.isDigitChar(this.lastChar) || this.isHexDigit(this.lastChar)) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
            }
        } else {
            while (this.isDigitChar(this.lastChar)) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
            }
        }
        String string = stringBuffer.toString();
        try {
            if (-1 != string.indexOf(46)) {
                return Double.valueOf(string);
            }
            String string2 = "";
            if (string.startsWith("-")) {
                string2 = "-";
                string = string.substring(1);
            }
            if (bl) {
                Long l = Long.valueOf(string2 + string.substring(2), 16);
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return new Integer(l.intValue());
                }
                return l;
            }
            if (string.equals("0")) {
                return new Integer(0);
            }
            if (string.startsWith("0") && string.length() > 1) {
                Long l = Long.valueOf(string2 + string.substring(1), 8);
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return new Integer(l.intValue());
                }
                return l;
            }
            if (string.indexOf("e") != -1 || string.indexOf("E") != -1) {
                return Double.valueOf(string2 + string);
            }
            Long l = Long.valueOf(string2 + string, 10);
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return new Integer(l.intValue());
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            IOException iOException = new IOException("Invalid number literal " + this.onLineCol(n, n2));
            iOException.initCause(numberFormatException);
            throw iOException;
        }
    }

    private boolean isHexDigit(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return true;
            }
        }
        return false;
    }

    private boolean isOctalDigit(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    private boolean isDigitChar(int n) {
        switch (n) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 88: 
            case 101: 
            case 120: {
                return true;
            }
        }
        return false;
    }

    private String readIdentifier() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.strict) {
            while (-1 != this.lastChar && Character.isLetter((char)this.lastChar)) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
            }
        } else {
            while (-1 != this.lastChar && this.isValidUnquotedChar((char)this.lastChar)) {
                stringBuffer.append((char)this.lastChar);
                this.readChar();
            }
        }
        return stringBuffer.toString();
    }

    private void readChar() throws IOException {
        if (10 == this.lastChar) {
            this.colNo = 0;
            ++this.lineNo;
        }
        this.lastChar = this.reader.read();
        if (-1 == this.lastChar) {
            return;
        }
        ++this.colNo;
    }

    private String onLineCol(int n, int n2) {
        return "on line " + n + ", column " + n2;
    }

    public String onLineCol() {
        return this.onLineCol(this.lineNo, this.colNo);
    }

    public boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u000e': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public boolean isValidUnquotedChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '$': 
            case '+': 
            case '-': 
            case '.': 
            case '@': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

