/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.commands;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.InfoHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class InfoCommand
extends Command {
    private InfoHandler m_handler = new InfoHandler();

    public InfoCommand() {
    }

    public InfoCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.getMessage("command.analyze.namespace", new Object[0]));
        this.setName("info");
        this.setDescription(Messages.getMessage("command.info.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
    }

    public Command createCommand(String[] args) {
        return new InfoCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        String jobId = null;
        if (cmd.hasOption("i")) {
            jobId = cmd.getOptionValue("i");
        }
        try {
            this.m_handler.info(jobId, cmd.hasOption("json"));
        }
        catch (AppScanException e) {
            CommonCLICore.getLogManager().log(new Message((Throwable)e));
            CommonCLICore.getIOConsole().println(new Message((Throwable)e));
        }
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.jobid.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("option.jobid.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withDescription((String)Messages.getMessage("option.json.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"json"));
        return options;
    }
}

