/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpPart;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class FileHandler
implements SaaSConstants {
    private AuthenticationProvider m_authProvider = new AuthenticationProvider();
    private HttpClient m_httpClient = new HttpClient();
    private IProgress m_progress = new ProgressAdapter();
    private static final int FILE_SIZE = 0x200000;

    public void setProgressAdapter(IProgress progress) {
        this.m_progress = progress;
    }

    public String uploadFile(File file) throws IOException, JSONException {
        if (file.length() / 1024L > 0x200000L) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("err.file.size", new Object[0])));
            return null;
        }
        String fileUploadAPI = this.m_authProvider.getServer() + "/api/v4/FileUpload";
        if (!FileUtil.getFileExtension((File)file).equalsIgnoreCase("irx")) {
            fileUploadAPI = fileUploadAPI + "?fileType=SourceCodeArchive";
        }
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("uploadedFile", file, "multipart/form-data"));
        HttpResponse response = this.m_httpClient.postMultipart(fileUploadAPI, this.m_authProvider.getAuthorizationHeader(), parts);
        JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
        if (!object.has("Message")) {
            return object.getString("FileId");
        }
        this.m_progress.setStatus(new Message(4, object.getString("Message")));
        return null;
    }
}

