/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jee;

import com.hcl.appscan.discovery.java.classpathManager.ClasspathManager;
import com.hcl.appscan.discovery.java.utils.IClasspathContributor;
import com.hcl.appscan.discovery.java.utils.IJavaStrategy;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.build.BuilderDefinition;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.ClasspathBuilder;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.jee.Messages;
import com.ibm.appscan.discovery.jsp.compilers.BaseJSPCompiler;
import com.ibm.appscan.discovery.jsp.compilers.JSPCompilerClasspathContributor;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class WARStrategy
extends CrawlingStrategy {
    private static final String WEB_INF_LIB = "WEB-INF/lib/";
    private static final String WEB_INF_CLASSES = "classes";
    private File m_crawlRoot;
    private String[] m_categories;
    private Set<String> m_userBasePackages;
    private BaseExclusion m_excluder;

    public WARStrategy() {
    }

    public WARStrategy(File file, IStrategyFactoryRegistry registry) {
        this.init(file, registry);
    }

    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_userBasePackages = new HashSet<String>();
        super.init(file, registry);
    }

    public String getType() {
        return "bytecode";
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLanguageType() {
        return "Java";
    }

    protected boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        proxy.inheritedSetBuildInfo("additional_classpath", null);
        proxy.inheritedSetBuildInfo("jsp_compiler", "Default Tomcat JSP Compiler");
        File target = this.getRoot(proxy);
        String parentPath = target.getParent();
        if (target.isFile()) {
            this.m_crawlRoot = this.getStagingDirectory(true, target.getName());
            try {
                Iterator iterator = ArchiveUtil.unzip((File)target, (File)this.m_crawlRoot, (String[])new String[0]).iterator();
                while (iterator.hasNext()) {
                    Message message;
                    Message message2 = message = (Message)iterator.next();
                    message2.getClass();
                    message.setMessageSource(new Message.MessageSource(message2, proxy.getPath(), null));
                    proxy.getLogManager().log(message);
                }
            }
            catch (AppScanException | IOException e) {
                proxy.getErrorManager().reportError(e.getMessage(), e);
                return false;
            }
        } else {
            this.m_crawlRoot = target;
        }
        ClasspathBuilder builder = new ClasspathBuilder(proxy);
        builder.appendToClasspath(this.m_crawlRoot, parentPath);
        builder.appendToClasspath(ClasspathManager.getParentClasspath((IScanTargetMinProxy)proxy));
        builder.commit();
        String web_content_dir = proxy.getBuildInfo().getProperty("web_content_dir");
        if (web_content_dir == null) {
            web_content_dir = PathUtil.makeRelative((File)proxy.getScanHome(), (File)proxy.getWorkingDirectory(), (File)this.m_crawlRoot).getPath();
        }
        proxy.getBuildInfo().setProperty("web_content_dir", web_content_dir);
        return true;
    }

    protected boolean buildScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        Object builder;
        this.m_categories = new String[]{"category.java", "category.jsp", "category.clientjs"};
        String compilerName = proxy.getBuildInfo().getProperty("jsp_compiler");
        if (compilerName == null) {
            return true;
        }
        if (compilerName.equals("NONE")) {
            this.m_categories = new String[]{"category.java", "category.clientjs"};
            return true;
        }
        BuilderDefinition definition = CommonCore.getBuildManager().getBuilder(compilerName);
        if (definition != null && (builder = definition.newBuilder()) instanceof BaseJSPCompiler) {
            BaseJSPCompiler compiler = (BaseJSPCompiler)builder;
            File outDir = new File(this.getStagingDirectory(true).getParentFile(), "p");
            ClasspathUtil.appendToClasspath((String)outDir.getPath(), (IScanTargetMinProxy)proxy, (boolean)true);
            compiler.init(proxy, this.m_crawlRoot, outDir);
            compiler.exec(progress);
            proxy.getProperties().put("jsp_compiler", compiler);
            proxy.getBuildInfo().setProperty("web_server_type", compiler.getServerType());
            return true;
        }
        proxy.getErrorManager().reportError(Messages.getMessage("err.jsp.compiler", compilerName), "jsp_compiler");
        return false;
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        ClasspathUtil.appendToClasspath((String)new File(this.m_crawlRoot, "WEB-INF/classes").getPath(), (IScanTargetMinProxy)proxy, (boolean)true);
        Set files = super.findScanFiles(proxy, progress);
        return files;
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_crawlRoot;
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return this.m_categories;
    }

    protected boolean handle(File file, String path, IScanTargetMinProxy proxy) {
        if (file.getName().toLowerCase().endsWith(".class")) {
            this.handleClassFile(path);
        }
        if (path.toLowerCase().endsWith(".jar")) {
            if (path.startsWith(WEB_INF_LIB)) {
                ClasspathUtil.appendToClasspath((String)file.getAbsolutePath(), (IScanTargetMinProxy)proxy, (boolean)true);
                if (this.isUserJar(file, proxy) || this.isJarUserIncluded(file, proxy) || SystemUtil.isDryRun()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isJarUserIncluded(File file, IScanTargetMinProxy proxy) {
        String path = file.getPath();
        Set includes = proxy.getIncludes();
        if (this.matchFound(path, proxy.getExcludes()) || includes.isEmpty()) {
            return false;
        }
        return this.matchFound(path, includes);
    }

    private boolean matchFound(String path, Set<StringPattern> set) {
        for (StringPattern pattern : set) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }

    private void handleClassFile(String classFileName) {
        String classWithFullyQualifiedPath;
        String basePackage;
        if (classFileName.endsWith(".class") && classFileName.contains(WEB_INF_CLASSES) && !(basePackage = this.getBasePackageFromClassWithFullyQualifiedPath(classWithFullyQualifiedPath = classFileName.substring(classFileName.lastIndexOf(WEB_INF_CLASSES) + WEB_INF_CLASSES.length() + 1))).isEmpty()) {
            this.m_userBasePackages.add(basePackage);
        }
    }

    private String getBasePackageFromClassWithFullyQualifiedPath(String classWithFullyQualifiedPath) {
        String basePackage = "";
        String fullyQualifiedClass = classWithFullyQualifiedPath.replaceAll("/", "\\.");
        if (fullyQualifiedClass.endsWith(".class") && (fullyQualifiedClass = fullyQualifiedClass.substring(0, fullyQualifiedClass.lastIndexOf("."))).contains(".")) {
            basePackage = fullyQualifiedClass.substring(fullyQualifiedClass.indexOf(".") + 1).contains(".") ? fullyQualifiedClass.substring(0, fullyQualifiedClass.indexOf(".", fullyQualifiedClass.indexOf(".") + 1)) : fullyQualifiedClass.substring(0, fullyQualifiedClass.indexOf("."));
        }
        return basePackage;
    }

    private boolean isUserJar(File file, IScanTargetMinProxy proxy) {
        try {
            Set<String> classes = this.getBasePackagesFromJar(file);
            for (String klass : classes) {
                if (!(this.m_userBasePackages.isEmpty() ? !this.getExcluder().isClassExcluded(klass) : this.m_userBasePackages.contains(klass))) continue;
                return true;
            }
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(e.getMessage(), (Throwable)e);
        }
        catch (ExclusionException e) {
            e.printStackTrace();
        }
        return false;
    }

    private Set<String> getBasePackagesFromJar(File file) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        try (JarInputStream jarFileInputStream = new JarInputStream(new FileInputStream(file));){
            JarEntry jarEntry = jarFileInputStream.getNextJarEntry();
            while (jarEntry != null) {
                String classWithFullyQualifiedPath;
                String basePackage;
                if (jarEntry.getName().endsWith(".class") && !(basePackage = this.getBasePackageFromClassWithFullyQualifiedPath(classWithFullyQualifiedPath = jarEntry.getName())).isEmpty()) {
                    packages.add(basePackage);
                }
                jarEntry = jarFileInputStream.getNextJarEntry();
            }
        }
        return packages;
    }

    protected void createScanTarget(IScanTargetProxy proxy, ScanTargetStrategy strategy) {
        String jspCompiler;
        if (strategy instanceof IJavaStrategy && (jspCompiler = proxy.getBuildInfo().getProperty("jsp_compiler")) != null && !"NONE".equals(jspCompiler)) {
            ((IJavaStrategy)strategy).addClasspathContributor((IClasspathContributor)new JSPCompilerClasspathContributor(jspCompiler));
        }
        super.createScanTarget(proxy, strategy);
    }

    protected BaseExclusion getExcluder() throws ExclusionException {
        if (this.m_excluder == null) {
            this.m_excluder = ExclusionProvider.getExclusion((String)"java");
        }
        return this.m_excluder;
    }
}

