/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.common;

import com.hcl.appscan.ifa.common.IIfaLog;
import com.hcl.appscan.ifa.common.Messages;
import com.hcl.appscan.ifa.common.util.DisplayClassName;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.logging.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class IfaLog
extends IIfaLog {
    private ArrayList<IfaLogRow> m_rows = new ArrayList();
    private Optional<IfaLogRow> m_row = Optional.empty();

    @Override
    protected void logInclude(Finding f) {
        this.m_row.get().m_included++;
    }

    @Override
    protected void logExclude(Finding f) {
        this.m_row.get().m_excluded++;
    }

    @Override
    protected void newRow(String ifaName, int nFindings) {
        this.m_row = Optional.of(new IfaLogRow(ifaName, nFindings));
        this.m_rows.add(this.m_row.get());
    }

    @Override
    protected void logException(Exception e) {
        this.m_row.get().m_exceptions.add(e);
    }

    @Override
    public String toString() {
        this.m_row = Optional.empty();
        StringBuffer str = new StringBuffer();
        for (IfaLogRow r : this.m_rows) {
            str.append(DisplayClassName.getDisplayClassName(r.m_ifaName));
            str.append(System.getProperty("line.separator"));
            str.append(Messages.getMessage("ifa.nlp.ingest", r.m_initial));
            str.append(System.getProperty("line.separator"));
            str.append(Messages.getMessage("ifa.nlp.include", r.m_included));
            str.append(System.getProperty("line.separator"));
            str.append(Messages.getMessage("ifa.nlp.exclude", r.m_excluded));
            str.append(System.getProperty("line.separator"));
            str.append(Messages.getMessage("ifa.nlp.unhandle", r.m_initial - r.m_included - r.m_excluded));
            str.append(System.getProperty("line.separator"));
            str.append(Messages.getMessage("separator", new Object[0]));
            str.append(System.getProperty("line.separator"));
        }
        return str.toString();
    }

    @Override
    public Collection<Exception> getExceptions() {
        this.m_row = Optional.empty();
        ArrayList<Exception> err_arr = new ArrayList<Exception>();
        this.m_rows.forEach(row -> err_arr.addAll(((IfaLogRow)row).m_exceptions));
        return err_arr;
    }

    @Override
    protected void addMessage(Message m) {
        this.m_row.get().m_messages.add(m);
    }

    @Override
    public Collection<Message> getLayerMessages() {
        this.m_row = Optional.empty();
        ArrayList<Message> message_arr = new ArrayList<Message>();
        for (IfaLogRow row : this.m_rows) {
            message_arr.addAll(row.m_messages);
        }
        return message_arr;
    }

    private class IfaLogRow {
        private final String m_ifaName;
        private ArrayList<Exception> m_exceptions = new ArrayList();
        private ArrayList<Message> m_messages = new ArrayList();
        private final int m_initial;
        private int m_included = 0;
        private int m_excluded = 0;

        private IfaLogRow(String ifaName, int nFindings) {
            this.m_ifaName = ifaName;
            this.m_initial = nFindings;
        }
    }
}

